/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.api.item;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ItemContext {
    private final Map<String, Object> map;

    public ItemContext(Map<String, Object> map) {
        this.map = map;
    }

    public static ItemContextBuilder builder() {
        return new ItemContextBuilder();
    }

    public Map<String, Object> getMap() {
        return this.map;
    }

    public static class ItemContextBuilder {
        private final Map<String, Object> map = new ConcurrentHashMap<String, Object>();

        public ItemContextBuilder material(String material) {
            this.map.put("material", material);
            return this;
        }

        public ItemContextBuilder pos(String pos) {
            this.map.put("pos", pos);
            return this;
        }

        public ItemContextBuilder group(String group) {
            this.map.put("group", group);
            return this;
        }

        public ItemContextBuilder order(int order) {
            this.map.put("order", order);
            return this;
        }

        public ItemContextBuilder set(String key, Object value) {
            this.map.put(key, value);
            return this;
        }

        public ItemContext build() {
            return new ItemContext(this.map);
        }
    }
}

