/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.api.event.loot;

import dev.aurelium.auraskills.api.loot.LootDropCause;
import dev.aurelium.auraskills.api.user.SkillsUser;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LootDropEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final Player player;
    private final SkillsUser user;
    private ItemStack item;
    private Location location;
    private final Cause cause;
    private boolean toInventory;
    private Entity entity;
    private boolean cancelled = false;

    public LootDropEvent(Player player, SkillsUser user, ItemStack item, Location location, Cause cause, boolean toInventory) {
        this.player = player;
        this.user = user;
        this.item = item;
        this.location = location;
        this.cause = cause;
        this.toInventory = toInventory;
    }

    public LootDropEvent(Player player, SkillsUser user, Entity entity, Location location, Cause cause) {
        this.player = player;
        this.user = user;
        this.location = location;
        this.cause = cause;
        this.toInventory = false;
        this.entity = entity;
        this.item = new ItemStack(Material.AIR);
    }

    @Nullable
    public Entity getEntity() {
        return this.entity;
    }

    public Player getPlayer() {
        return this.player;
    }

    public SkillsUser getUser() {
        return this.user;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public LootDropEvent setItem(ItemStack item) {
        this.item = item;
        return this;
    }

    public Location getLocation() {
        return this.location;
    }

    public LootDropEvent setLocation(Location location) {
        this.location = location;
        return this;
    }

    public Cause getCause() {
        return this.cause;
    }

    public boolean isToInventory() {
        return this.toInventory;
    }

    public void setToInventory(boolean toInventory) {
        this.toInventory = toInventory;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public static enum Cause implements LootDropCause
    {
        TREASURE_HUNTER,
        EPIC_CATCH,
        METAL_DETECTOR,
        LUCKY_SPADES,
        LUCK_DOUBLE_DROP,
        FISHING_OTHER_LOOT,
        EXCAVATION_OTHER_LOOT,
        MINING_OTHER_LOOT,
        FORAGING_OTHER_LOOT,
        FARMING_OTHER_LOOT,
        UNKNOWN,
        MOB_LOOT_TABLE,
        FARMING_LUCK,
        FORAGING_LUCK,
        MINING_LUCK,
        FISHING_LUCK,
        EXCAVATION_LUCK;

    }
}

