/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.acf;

import dev.aurelium.auraskills.acf.ACFPatterns;
import dev.aurelium.auraskills.acf.ACFUtil;
import dev.aurelium.auraskills.acf.BukkitCommandCompletionContext;
import dev.aurelium.auraskills.acf.BukkitCommandManager;
import dev.aurelium.auraskills.acf.CommandCompletions;
import dev.aurelium.auraskills.acf.bukkit.contexts.OnlinePlayer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.generator.WorldInfo;
import org.bukkit.util.StringUtil;

public class BukkitCommandCompletions
extends CommandCompletions<BukkitCommandCompletionContext> {
    public BukkitCommandCompletions(BukkitCommandManager manager) {
        super(manager);
        this.registerAsyncCompletion("mobs", c -> {
            Stream<String> normal = Stream.of(EntityType.values()).map(entityType -> ACFUtil.simplifyString(entityType.getName()));
            return normal.collect(Collectors.toList());
        });
        this.registerAsyncCompletion("chatcolors", c -> {
            String filter;
            Stream<ChatColor> colors = Stream.of(ChatColor.values());
            if (c.hasConfig("colorsonly")) {
                colors = colors.filter(color -> color.ordinal() <= 15);
            }
            if ((filter = c.getConfig("filter")) != null) {
                Set filters = Arrays.stream(ACFPatterns.COLON.split(filter)).map(ACFUtil::simplifyString).collect(Collectors.toSet());
                colors = colors.filter(color -> filters.contains(ACFUtil.simplifyString(color.name())));
            }
            return colors.map(color -> ACFUtil.simplifyString(color.name())).collect(Collectors.toList());
        });
        this.registerAsyncCompletion("dyecolors", c -> ACFUtil.enumNames(DyeColor.values()));
        this.registerCompletion("worlds", c -> Bukkit.getWorlds().stream().map(WorldInfo::getName).collect(Collectors.toList()));
        this.registerCompletion("players", c -> {
            CommandSender sender = c.getSender();
            Validate.notNull((Object)sender, (String)"Sender cannot be null");
            Player senderPlayer = sender instanceof Player ? (Player)sender : null;
            ArrayList<String> matchedPlayers = new ArrayList<String>();
            for (Player player : Bukkit.getOnlinePlayers()) {
                String name = player.getName();
                if (senderPlayer != null && !senderPlayer.canSee(player) || !StringUtil.startsWithIgnoreCase((String)name, (String)c.getInput())) continue;
                matchedPlayers.add(name);
            }
            matchedPlayers.sort(String.CASE_INSENSITIVE_ORDER);
            return matchedPlayers;
        });
        this.setDefaultCompletion("players", OnlinePlayer.class, dev.aurelium.auraskills.acf.contexts.OnlinePlayer.class, Player.class);
        this.setDefaultCompletion("worlds", World.class);
    }
}

