/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.slate.inv.content;

public class SlotPos {
    private final int row;
    private final int column;

    public SlotPos(int row, int column) {
        this.row = row;
        this.column = column;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SlotPos slotPos = (SlotPos)obj;
        return this.row == slotPos.row && this.column == slotPos.column;
    }

    public int hashCode() {
        int result = this.row;
        result = 31 * result + this.column;
        return result;
    }

    public String toString() {
        return "SlotPos{row=" + this.row + ", column=" + this.column + "}";
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public static SlotPos of(int row, int column) {
        return new SlotPos(row, column);
    }

    public static SlotPos parse(String input) {
        String[] split = input.split(",");
        int row = 0;
        int column = 0;
        try {
            row = Integer.parseInt(split[0]);
            if (split.length > 1) {
                column = Integer.parseInt(split[1]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new SlotPos(row, column);
    }
}

