/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.slate.fill;

import dev.aurelium.auraskills.slate.Slate;
import dev.aurelium.auraskills.slate.builder.BuiltItem;
import dev.aurelium.auraskills.slate.fill.FillItem;
import dev.aurelium.auraskills.slate.info.ItemInfo;
import dev.aurelium.auraskills.slate.inv.ClickableItem;
import dev.aurelium.auraskills.slate.inv.content.SlotPos;
import dev.aurelium.auraskills.slate.lore.LoreLine;
import dev.aurelium.auraskills.slate.menu.MenuInventory;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public record FillData(FillItem item, SlotPos[] slots, boolean enabled) {
    public static FillData empty(Slate slate) {
        return new FillData(new FillItem(slate, new ItemStack(Material.BLACK_STAINED_GLASS_PANE)), new SlotPos[0], false);
    }

    public void placeInMenu(Slate slate, Player player, MenuInventory inv) {
        ItemStack itemStack;
        ItemMeta meta;
        FillItem fillItem = this.item;
        ItemStack providedFill = inv.getBuiltMenu().fillItem().modify(new ItemInfo(slate, player, inv.getActiveMenu(), fillItem.getBaseItem()));
        if (providedFill != null) {
            fillItem = new FillItem(slate, providedFill);
        }
        if ((meta = (itemStack = fillItem.getBaseItem()).getItemMeta()) != null) {
            List<LoreLine> loreLines;
            String displayName = fillItem.getDisplayName();
            if (displayName != null) {
                inv.setDisplayName(meta, inv.getTextFormatter().toComponent(displayName));
            }
            if ((loreLines = fillItem.getLore()) != null) {
                inv.setLore(meta, inv.getLoreInterpreter().interpretLore(loreLines, player, inv.getActiveMenu(), BuiltItem.createEmpty(), fillItem));
            }
            itemStack.setItemMeta(meta);
        }
        if (this.slots == null) {
            inv.getContents().fill(ClickableItem.empty(itemStack));
        } else {
            for (SlotPos slot : this.slots) {
                inv.getContents().set(slot, ClickableItem.empty(itemStack));
            }
        }
    }
}

