/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.slate.builder;

import dev.aurelium.auraskills.slate.Slate;
import dev.aurelium.auraskills.slate.action.trigger.ClickTrigger;
import dev.aurelium.auraskills.slate.function.ItemClicker;
import dev.aurelium.auraskills.slate.function.ItemModifier;
import dev.aurelium.auraskills.slate.function.ItemReplacer;
import dev.aurelium.auraskills.slate.function.MenuListener;
import dev.aurelium.auraskills.slate.info.ItemInfo;
import dev.aurelium.auraskills.slate.info.PlaceholderInfo;
import dev.aurelium.auraskills.slate.item.ItemClick;
import dev.aurelium.auraskills.slate.item.provider.PlaceholderData;
import dev.aurelium.auraskills.slate.item.provider.PlaceholderType;
import dev.aurelium.auraskills.slate.lore.ListData;
import dev.aurelium.auraskills.slate.lore.LoreInterpreter;
import dev.aurelium.auraskills.slate.menu.ActiveMenu;
import dev.aurelium.auraskills.slate.util.LoreUtil;
import dev.aurelium.auraskills.slate.util.Pair;
import dev.aurelium.auraskills.slate.util.TextUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public record BuiltItem(Map<String, ItemReplacer> replacers, ItemReplacer anyReplacer, Map<ClickTrigger, ItemClicker> clickers, @NotNull ItemModifier modifier, MenuListener initListener) {
    public static BuiltItem createEmpty() {
        return new BuiltItem(new HashMap<String, ItemReplacer>(), p -> null, new HashMap<ClickTrigger, ItemClicker>(), ItemInfo::item, m -> {});
    }

    public String applyReplacers(String input, Slate slate, Player player, ActiveMenu activeMenu, PlaceholderType type) {
        input = slate.getGlobalBehavior().applyGlobalReplacers(input, slate, player, activeMenu, type);
        String[] placeholders = TextUtil.substringsBetween(input, "{", "}");
        if (placeholders != null) {
            String style = LoreUtil.getStyle(input);
            for (String placeholder : placeholders) {
                Pair<String, ListData> pair = LoreInterpreter.detectListPlaceholder(placeholder);
                PlaceholderData data = new PlaceholderData(type, style, pair.second());
                String coreName = pair.first();
                PlaceholderInfo info = new PlaceholderInfo(slate, player, coreName, activeMenu, data);
                for (Map.Entry<String, ItemReplacer> entry : this.replacers.entrySet()) {
                    String replaced;
                    if (!entry.getKey().equals(coreName) || (replaced = entry.getValue().replace(info)) == null) continue;
                    input = TextUtil.replace(input, "{" + placeholder + "}", replaced);
                }
                String replaced = this.anyReplacer.replace(info);
                if (replaced == null) continue;
                input = TextUtil.replace(input, "{" + placeholder + "}", replaced);
            }
        }
        return input;
    }

    public void handleClick(Set<ClickTrigger> actions, ItemClick itemClick) {
        for (Map.Entry<ClickTrigger, ItemClicker> entry : this.clickers.entrySet()) {
            if (!actions.contains((Object)entry.getKey())) continue;
            entry.getValue().click(itemClick);
        }
    }
}

