/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.querz.mca;

import dev.aurelium.auraskills.querz.mca.CompressionType;
import dev.aurelium.auraskills.querz.mca.MCAUtil;
import dev.aurelium.auraskills.querz.mca.Section;
import dev.aurelium.auraskills.querz.nbt.io.NBTDeserializer;
import dev.aurelium.auraskills.querz.nbt.io.NBTSerializer;
import dev.aurelium.auraskills.querz.nbt.io.NamedTag;
import dev.aurelium.auraskills.querz.nbt.tag.CompoundTag;
import dev.aurelium.auraskills.querz.nbt.tag.ListTag;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;

public class Chunk {
    public static final int DEFAULT_DATA_VERSION = 2567;
    private boolean partial;
    private boolean raw;
    private int lastMCAUpdate;
    private CompoundTag data;
    private int dataVersion;
    private long lastUpdate;
    private long inhabitedTime;
    private int[] biomes;
    private CompoundTag heightMaps;
    private CompoundTag carvingMasks;
    private Section[] sections = new Section[16];
    private ListTag<CompoundTag> entities;
    private ListTag<CompoundTag> tileEntities;
    private ListTag<CompoundTag> tileTicks;
    private ListTag<CompoundTag> liquidTicks;
    private ListTag<ListTag<?>> lights;
    private ListTag<ListTag<?>> liquidsToBeTicked;
    private ListTag<ListTag<?>> toBeTicked;
    private ListTag<ListTag<?>> postProcessing;
    private String status;
    private CompoundTag structures;

    Chunk(int lastMCAUpdate) {
        this.lastMCAUpdate = lastMCAUpdate;
    }

    public Chunk(CompoundTag data) {
        this.data = data;
        this.initReferences(-1L);
    }

    private void initReferences(long loadFlags) {
        if (this.data == null) {
            throw new NullPointerException("data cannot be null");
        }
        if (loadFlags != -1L && (loadFlags & 0x10000L) != 0L) {
            this.raw = true;
            return;
        }
        CompoundTag level = this.data.getCompoundTag("Level");
        if (level == null) {
            throw new IllegalArgumentException("data does not contain \"Level\" tag");
        }
        this.dataVersion = this.data.getInt("DataVersion");
        this.inhabitedTime = level.getLong("InhabitedTime");
        this.lastUpdate = level.getLong("LastUpdate");
        if ((loadFlags & 1L) != 0L) {
            this.biomes = level.getIntArray("Biomes");
        }
        if ((loadFlags & 2L) != 0L) {
            this.heightMaps = level.getCompoundTag("Heightmaps");
        }
        if ((loadFlags & 4L) != 0L) {
            this.carvingMasks = level.getCompoundTag("CarvingMasks");
        }
        if ((loadFlags & 8L) != 0L) {
            ListTag<CompoundTag> listTag = this.entities = level.containsKey("Entities") ? level.getListTag("Entities").asCompoundTagList() : null;
        }
        if ((loadFlags & 0x10L) != 0L) {
            ListTag<CompoundTag> listTag = this.tileEntities = level.containsKey("TileEntities") ? level.getListTag("TileEntities").asCompoundTagList() : null;
        }
        if ((loadFlags & 0x40L) != 0L) {
            ListTag<CompoundTag> listTag = this.tileTicks = level.containsKey("TileTicks") ? level.getListTag("TileTicks").asCompoundTagList() : null;
        }
        if ((loadFlags & 0x80L) != 0L) {
            ListTag<CompoundTag> listTag = this.liquidTicks = level.containsKey("LiquidTicks") ? level.getListTag("LiquidTicks").asCompoundTagList() : null;
        }
        if ((loadFlags & 0x4000L) != 0L) {
            ListTag<ListTag<?>> listTag = this.lights = level.containsKey("Lights") ? level.getListTag("Lights").asListTagList() : null;
        }
        if ((loadFlags & 0x8000L) != 0L) {
            ListTag<ListTag<?>> listTag = this.liquidsToBeTicked = level.containsKey("LiquidsToBeTicked") ? level.getListTag("LiquidsToBeTicked").asListTagList() : null;
        }
        if ((loadFlags & 0x100L) != 0L) {
            ListTag<ListTag<?>> listTag = this.toBeTicked = level.containsKey("ToBeTicked") ? level.getListTag("ToBeTicked").asListTagList() : null;
        }
        if ((loadFlags & 0x200L) != 0L) {
            this.postProcessing = level.containsKey("PostProcessing") ? level.getListTag("PostProcessing").asListTagList() : null;
        }
        this.status = level.getString("Status");
        if ((loadFlags & 0x400L) != 0L) {
            this.structures = level.getCompoundTag("Structures");
        }
        if ((loadFlags & 0x3800L) != 0L && level.containsKey("Sections")) {
            for (CompoundTag section : level.getListTag("Sections").asCompoundTagList()) {
                Section newSection;
                byte sectionIndex = section.getByte("Y");
                if (sectionIndex > 15 || sectionIndex < 0 || (newSection = new Section(section, this.dataVersion, loadFlags)).isEmpty()) continue;
                this.sections[sectionIndex] = newSection;
            }
        }
        if (loadFlags != -1L) {
            this.data = null;
            this.partial = true;
        }
    }

    public int serialize(RandomAccessFile raf, int xPos, int zPos) throws IOException {
        if (this.partial) {
            throw new UnsupportedOperationException("Partially loaded chunks cannot be serialized");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        try (BufferedOutputStream nbtOut = new BufferedOutputStream(CompressionType.ZLIB.compress(baos));){
            new NBTSerializer(false).toStream(new NamedTag(null, this.updateHandle(xPos, zPos)), (OutputStream)nbtOut);
        }
        byte[] rawData = baos.toByteArray();
        raf.writeInt(rawData.length + 1);
        raf.writeByte(CompressionType.ZLIB.getID());
        raf.write(rawData);
        return rawData.length + 5;
    }

    public void deserialize(RandomAccessFile raf) throws IOException {
        this.deserialize(raf, -1L);
    }

    public void deserialize(RandomAccessFile raf, long loadFlags) throws IOException {
        byte compressionTypeByte = raf.readByte();
        CompressionType compressionType = CompressionType.getFromID(compressionTypeByte);
        if (compressionType == null) {
            throw new IOException("invalid compression type " + compressionTypeByte);
        }
        BufferedInputStream dis = new BufferedInputStream(compressionType.decompress(new FileInputStream(raf.getFD())));
        NamedTag tag = new NBTDeserializer(false).fromStream(dis);
        if (tag == null || !(tag.getTag() instanceof CompoundTag)) {
            throw new IOException("invalid data tag: " + (tag == null ? "null" : tag.getClass().getName()));
        }
        this.data = (CompoundTag)tag.getTag();
        this.initReferences(loadFlags);
    }

    @Deprecated
    public int getBiomeAt(int blockX, int blockZ) {
        if (this.dataVersion < 2202) {
            if (this.biomes == null || this.biomes.length != 256) {
                return -1;
            }
            return this.biomes[this.getBlockIndex(blockX, blockZ)];
        }
        throw new IllegalStateException("cannot get biome using Chunk#getBiomeAt(int,int) from biome data with DataVersion of 2202 or higher, use Chunk#getBiomeAt(int,int,int) instead");
    }

    public int getBiomeAt(int blockX, int blockY, int blockZ) {
        if (this.dataVersion < 2202) {
            if (this.biomes == null || this.biomes.length != 256) {
                return -1;
            }
            return this.biomes[this.getBlockIndex(blockX, blockZ)];
        }
        if (this.biomes == null || this.biomes.length != 1024) {
            return -1;
        }
        int biomeX = (blockX & 0xF) >> 2;
        int biomeY = (blockY & 0xF) >> 2;
        int biomeZ = (blockZ & 0xF) >> 2;
        return this.biomes[this.getBiomeIndex(biomeX, biomeY, biomeZ)];
    }

    @Deprecated
    public void setBiomeAt(int blockX, int blockZ, int biomeID) {
        this.checkRaw();
        if (this.dataVersion < 2202) {
            if (this.biomes == null || this.biomes.length != 256) {
                this.biomes = new int[256];
                Arrays.fill(this.biomes, -1);
            }
            this.biomes[this.getBlockIndex((int)blockX, (int)blockZ)] = biomeID;
        } else {
            if (this.biomes == null || this.biomes.length != 1024) {
                this.biomes = new int[1024];
                Arrays.fill(this.biomes, -1);
            }
            int biomeX = (blockX & 0xF) >> 2;
            int biomeZ = (blockZ & 0xF) >> 2;
            for (int y = 0; y < 64; ++y) {
                this.biomes[this.getBiomeIndex((int)biomeX, (int)y, (int)biomeZ)] = biomeID;
            }
        }
    }

    public void setBiomeAt(int blockX, int blockY, int blockZ, int biomeID) {
        this.checkRaw();
        if (this.dataVersion < 2202) {
            if (this.biomes == null || this.biomes.length != 256) {
                this.biomes = new int[256];
                Arrays.fill(this.biomes, -1);
            }
            this.biomes[this.getBlockIndex((int)blockX, (int)blockZ)] = biomeID;
        } else {
            if (this.biomes == null || this.biomes.length != 1024) {
                this.biomes = new int[1024];
                Arrays.fill(this.biomes, -1);
            }
            int biomeX = (blockX & 0xF) >> 2;
            int biomeZ = (blockZ & 0xF) >> 2;
            this.biomes[this.getBiomeIndex((int)biomeX, (int)blockY, (int)biomeZ)] = biomeID;
        }
    }

    int getBiomeIndex(int biomeX, int biomeY, int biomeZ) {
        return biomeY * 16 + biomeZ * 4 + biomeX;
    }

    public CompoundTag getBlockStateAt(int blockX, int blockY, int blockZ) {
        Section section = this.sections[MCAUtil.blockToChunk(blockY)];
        if (section == null) {
            return null;
        }
        return section.getBlockStateAt(blockX, blockY, blockZ);
    }

    public void setBlockStateAt(int blockX, int blockY, int blockZ, CompoundTag state, boolean cleanup) {
        this.checkRaw();
        int sectionIndex = MCAUtil.blockToChunk(blockY);
        Section section = this.sections[sectionIndex];
        if (section == null) {
            section = this.sections[sectionIndex] = Section.newSection();
        }
        section.setBlockStateAt(blockX, blockY, blockZ, state, cleanup);
    }

    public int getDataVersion() {
        return this.dataVersion;
    }

    public void setDataVersion(int dataVersion) {
        this.checkRaw();
        this.dataVersion = dataVersion;
        for (Section section : this.sections) {
            if (section == null) continue;
            section.dataVersion = dataVersion;
        }
    }

    public int getLastMCAUpdate() {
        return this.lastMCAUpdate;
    }

    public void setLastMCAUpdate(int lastMCAUpdate) {
        this.checkRaw();
        this.lastMCAUpdate = lastMCAUpdate;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.checkRaw();
        this.status = status;
    }

    public Section getSection(int sectionY) {
        return this.sections[sectionY];
    }

    public void setSection(int sectionY, Section section) {
        this.checkRaw();
        this.sections[sectionY] = section;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(long lastUpdate) {
        this.checkRaw();
        this.lastUpdate = lastUpdate;
    }

    public long getInhabitedTime() {
        return this.inhabitedTime;
    }

    public void setInhabitedTime(long inhabitedTime) {
        this.checkRaw();
        this.inhabitedTime = inhabitedTime;
    }

    public int[] getBiomes() {
        return this.biomes;
    }

    public void setBiomes(int[] biomes) {
        this.checkRaw();
        if (biomes != null && (this.dataVersion < 2202 && biomes.length != 256 || this.dataVersion >= 2202 && biomes.length != 1024)) {
            throw new IllegalArgumentException("biomes array must have a length of " + (this.dataVersion < 2202 ? "256" : "1024"));
        }
        this.biomes = biomes;
    }

    public CompoundTag getHeightMaps() {
        return this.heightMaps;
    }

    public void setHeightMaps(CompoundTag heightMaps) {
        this.checkRaw();
        this.heightMaps = heightMaps;
    }

    public CompoundTag getCarvingMasks() {
        return this.carvingMasks;
    }

    public void setCarvingMasks(CompoundTag carvingMasks) {
        this.checkRaw();
        this.carvingMasks = carvingMasks;
    }

    public ListTag<CompoundTag> getEntities() {
        return this.entities;
    }

    public void setEntities(ListTag<CompoundTag> entities) {
        this.checkRaw();
        this.entities = entities;
    }

    public ListTag<CompoundTag> getTileEntities() {
        return this.tileEntities;
    }

    public void setTileEntities(ListTag<CompoundTag> tileEntities) {
        this.checkRaw();
        this.tileEntities = tileEntities;
    }

    public ListTag<CompoundTag> getTileTicks() {
        return this.tileTicks;
    }

    public void setTileTicks(ListTag<CompoundTag> tileTicks) {
        this.checkRaw();
        this.tileTicks = tileTicks;
    }

    public ListTag<CompoundTag> getLiquidTicks() {
        return this.liquidTicks;
    }

    public void setLiquidTicks(ListTag<CompoundTag> liquidTicks) {
        this.checkRaw();
        this.liquidTicks = liquidTicks;
    }

    public ListTag<ListTag<?>> getLights() {
        return this.lights;
    }

    public void setLights(ListTag<ListTag<?>> lights) {
        this.checkRaw();
        this.lights = lights;
    }

    public ListTag<ListTag<?>> getLiquidsToBeTicked() {
        return this.liquidsToBeTicked;
    }

    public void setLiquidsToBeTicked(ListTag<ListTag<?>> liquidsToBeTicked) {
        this.checkRaw();
        this.liquidsToBeTicked = liquidsToBeTicked;
    }

    public ListTag<ListTag<?>> getToBeTicked() {
        return this.toBeTicked;
    }

    public void setToBeTicked(ListTag<ListTag<?>> toBeTicked) {
        this.checkRaw();
        this.toBeTicked = toBeTicked;
    }

    public ListTag<ListTag<?>> getPostProcessing() {
        return this.postProcessing;
    }

    public void setPostProcessing(ListTag<ListTag<?>> postProcessing) {
        this.checkRaw();
        this.postProcessing = postProcessing;
    }

    public CompoundTag getStructures() {
        return this.structures;
    }

    public void setStructures(CompoundTag structures) {
        this.checkRaw();
        this.structures = structures;
    }

    int getBlockIndex(int blockX, int blockZ) {
        return (blockZ & 0xF) * 16 + (blockX & 0xF);
    }

    public void cleanupPalettesAndBlockStates() {
        this.checkRaw();
        for (Section section : this.sections) {
            if (section == null) continue;
            section.cleanupPaletteAndBlockStates();
        }
    }

    private void checkRaw() {
        if (this.raw) {
            throw new UnsupportedOperationException("cannot update field when working with raw data");
        }
    }

    public static Chunk newChunk() {
        return Chunk.newChunk(2567);
    }

    public static Chunk newChunk(int dataVersion) {
        Chunk c = new Chunk(0);
        c.dataVersion = dataVersion;
        c.data = new CompoundTag();
        c.data.put("Level", new CompoundTag());
        c.status = "mobs_spawned";
        return c;
    }

    public CompoundTag getHandle() {
        return this.data;
    }

    public CompoundTag updateHandle(int xPos, int zPos) {
        if (this.raw) {
            return this.data;
        }
        this.data.putInt("DataVersion", this.dataVersion);
        CompoundTag level = this.data.getCompoundTag("Level");
        level.putInt("xPos", xPos);
        level.putInt("zPos", zPos);
        level.putLong("LastUpdate", this.lastUpdate);
        level.putLong("InhabitedTime", this.inhabitedTime);
        if (this.dataVersion < 2202) {
            if (this.biomes != null && this.biomes.length == 256) {
                level.putIntArray("Biomes", this.biomes);
            }
        } else if (this.biomes != null && this.biomes.length == 1024) {
            level.putIntArray("Biomes", this.biomes);
        }
        if (this.heightMaps != null) {
            level.put("Heightmaps", this.heightMaps);
        }
        if (this.carvingMasks != null) {
            level.put("CarvingMasks", this.carvingMasks);
        }
        if (this.entities != null) {
            level.put("Entities", this.entities);
        }
        if (this.tileEntities != null) {
            level.put("TileEntities", this.tileEntities);
        }
        if (this.tileTicks != null) {
            level.put("TileTicks", this.tileTicks);
        }
        if (this.liquidTicks != null) {
            level.put("LiquidTicks", this.liquidTicks);
        }
        if (this.lights != null) {
            level.put("Lights", this.lights);
        }
        if (this.liquidsToBeTicked != null) {
            level.put("LiquidsToBeTicked", this.liquidsToBeTicked);
        }
        if (this.toBeTicked != null) {
            level.put("ToBeTicked", this.toBeTicked);
        }
        if (this.postProcessing != null) {
            level.put("PostProcessing", this.postProcessing);
        }
        level.putString("Status", this.status);
        if (this.structures != null) {
            level.put("Structures", this.structures);
        }
        ListTag<CompoundTag> sections = new ListTag<CompoundTag>(CompoundTag.class);
        for (int i = 0; i < this.sections.length; ++i) {
            if (this.sections[i] == null) continue;
            sections.add(this.sections[i].updateHandle(i));
        }
        level.put("Sections", sections);
        return this.data;
    }
}

