/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.evalex.operators.arithmetic;

import dev.aurelium.auraskills.evalex.EvaluationException;
import dev.aurelium.auraskills.evalex.Expression;
import dev.aurelium.auraskills.evalex.config.ExpressionConfiguration;
import dev.aurelium.auraskills.evalex.data.EvaluationValue;
import dev.aurelium.auraskills.evalex.operators.AbstractOperator;
import dev.aurelium.auraskills.evalex.operators.InfixOperator;
import dev.aurelium.auraskills.evalex.parser.Token;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

@InfixOperator(precedence=40, leftAssociative=false)
public class InfixPowerOfOperator
extends AbstractOperator {
    @Override
    public EvaluationValue evaluate(Expression expression, Token operatorToken, EvaluationValue ... operands) throws EvaluationException {
        EvaluationValue leftOperand = operands[0];
        EvaluationValue rightOperand = operands[1];
        if (leftOperand.isNumberValue() && rightOperand.isNumberValue()) {
            MathContext mathContext = expression.getConfiguration().getMathContext();
            BigDecimal v1 = leftOperand.getNumberValue();
            BigDecimal v2 = rightOperand.getNumberValue();
            int signOf2 = v2.signum();
            double dn1 = v1.doubleValue();
            v2 = v2.multiply(new BigDecimal(signOf2));
            BigDecimal remainderOf2 = v2.remainder(BigDecimal.ONE);
            BigDecimal n2IntPart = v2.subtract(remainderOf2);
            BigDecimal intPow = v1.pow(n2IntPart.intValueExact(), mathContext);
            BigDecimal doublePow = BigDecimal.valueOf(Math.pow(dn1, remainderOf2.doubleValue()));
            BigDecimal result = intPow.multiply(doublePow, mathContext);
            if (signOf2 == -1) {
                result = BigDecimal.ONE.divide(result, mathContext.getPrecision(), RoundingMode.HALF_UP);
            }
            return expression.convertValue(result);
        }
        throw EvaluationException.ofUnsupportedDataTypeInOperation(operatorToken);
    }

    @Override
    public int getPrecedence(ExpressionConfiguration configuration) {
        return configuration.getPowerOfPrecedence();
    }
}

