/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.evalex.functions.trigonometric;

import dev.aurelium.auraskills.evalex.EvaluationException;
import dev.aurelium.auraskills.evalex.Expression;
import dev.aurelium.auraskills.evalex.data.EvaluationValue;
import dev.aurelium.auraskills.evalex.functions.AbstractFunction;
import dev.aurelium.auraskills.evalex.functions.FunctionParameter;
import dev.aurelium.auraskills.evalex.parser.Token;

@FunctionParameter(name="value")
public class AtanHFunction
extends AbstractFunction {
    @Override
    public EvaluationValue evaluate(Expression expression, Token functionToken, EvaluationValue ... parameterValues) throws EvaluationException {
        double value = parameterValues[0].getNumberValue().doubleValue();
        if (Math.abs(value) >= 1.0) {
            throw new EvaluationException(functionToken, "Absolute value must be less than 1");
        }
        return expression.convertDoubleValue(0.5 * Math.log((1.0 + value) / (1.0 - value)));
    }
}

