/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.evalex.data.conversion;

import dev.aurelium.auraskills.evalex.config.ExpressionConfiguration;
import dev.aurelium.auraskills.evalex.data.EvaluationValue;
import dev.aurelium.auraskills.evalex.data.conversion.ArrayConverter;
import dev.aurelium.auraskills.evalex.data.conversion.BooleanConverter;
import dev.aurelium.auraskills.evalex.data.conversion.ConverterIfc;
import dev.aurelium.auraskills.evalex.data.conversion.DateTimeConverter;
import dev.aurelium.auraskills.evalex.data.conversion.DurationConverter;
import dev.aurelium.auraskills.evalex.data.conversion.EvaluationValueConverterIfc;
import dev.aurelium.auraskills.evalex.data.conversion.ExpressionNodeConverter;
import dev.aurelium.auraskills.evalex.data.conversion.NumberConverter;
import dev.aurelium.auraskills.evalex.data.conversion.StringConverter;
import dev.aurelium.auraskills.evalex.data.conversion.StructureConverter;
import java.util.Arrays;
import java.util.List;

public class DefaultEvaluationValueConverter
implements EvaluationValueConverterIfc {
    static final List<ConverterIfc> converters = Arrays.asList(new NumberConverter(), new StringConverter(), new BooleanConverter(), new DateTimeConverter(), new DurationConverter(), new ExpressionNodeConverter(), new ArrayConverter(), new StructureConverter());

    @Override
    public EvaluationValue convertObject(Object object, ExpressionConfiguration configuration) {
        if (object == null) {
            return EvaluationValue.NULL_VALUE;
        }
        if (object instanceof EvaluationValue) {
            return (EvaluationValue)object;
        }
        for (ConverterIfc converter : converters) {
            if (!converter.canConvert(object)) continue;
            return converter.convert(object, configuration);
        }
        if (configuration.isBinaryAllowed()) {
            return EvaluationValue.binaryValue(object);
        }
        throw new IllegalArgumentException("Unsupported data type '" + object.getClass().getName() + "'");
    }
}

