/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.user;

import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.stat.ReloadableIdentifier;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.stat.StatModifier;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.trait.TraitModifier;
import dev.aurelium.auraskills.api.util.AuraSkillsModifier;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.modifier.TemporaryModifier;
import dev.aurelium.auraskills.common.user.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public class UserStats {
    private final AuraSkillsPlugin plugin;
    private final User user;
    private final Map<Stat, Double> statLevels = new ConcurrentHashMap<Stat, Double>();
    private final Map<Stat, Double> baseStatLevels = new ConcurrentHashMap<Stat, Double>();
    private final Map<String, StatModifier> statModifiers = new ConcurrentHashMap<String, StatModifier>();
    private final Map<String, TraitModifier> traitModifiers = new ConcurrentHashMap<String, TraitModifier>();
    private final PriorityQueue<TemporaryModifier> tempModExpiryQueue = new PriorityQueue();

    public UserStats(AuraSkillsPlugin plugin, User user) {
        this.plugin = plugin;
        this.user = user;
    }

    public void removeExpiredModifiers() {
        long now = System.currentTimeMillis();
        while (!this.tempModExpiryQueue.isEmpty() && this.tempModExpiryQueue.peek().expirationTime() <= now) {
            TemporaryModifier expired = this.tempModExpiryQueue.poll();
            AuraSkillsModifier<?> modifier = expired.modifier();
            if (modifier instanceof StatModifier) {
                this.removeStatModifier(modifier.name(), true);
                continue;
            }
            if (!(modifier instanceof TraitModifier)) continue;
            this.removeTraitModifier(modifier.name(), true);
        }
    }

    public double getStatLevel(Stat stat) {
        return this.statLevels.getOrDefault(stat, 0.0);
    }

    public double getBaseStatLevel(Stat stat) {
        return this.baseStatLevels.getOrDefault(stat, 0.0);
    }

    @Nullable
    public StatModifier getStatModifier(String name) {
        return this.statModifiers.get(name);
    }

    public Map<String, StatModifier> getStatModifiers() {
        return this.statModifiers;
    }

    public void addStatModifier(StatModifier modifier, boolean reload) {
        this.addModifier(modifier, reload, this.statModifiers);
    }

    public void addTemporaryStatModifier(StatModifier modifier, boolean reload, long expirationTime) {
        if (!modifier.isTemporary()) {
            throw new IllegalArgumentException("Stat modifier is not a temporary stat modifier");
        }
        this.addModifier(modifier, reload, this.statModifiers);
        this.tempModExpiryQueue.add(new TemporaryModifier(modifier, expirationTime));
    }

    public boolean removeStatModifier(String name, boolean reload) {
        return this.removeModifier(name, reload, this.statModifiers);
    }

    public double getEffectiveTraitLevel(Trait trait) {
        double base = this.plugin.getTraitManager().getBaseLevel(this.user, trait);
        return base + this.getBonusTraitLevel(trait);
    }

    public double getBonusTraitLevel(Trait trait) {
        if (!trait.isEnabled() || this.plugin.getWorldManager().isDisabledWorld(this.user.getWorld())) {
            return 0.0;
        }
        double level = this.getTraitLevelFromStats(trait, 0.0);
        ArrayList<TraitModifier> modifiers = new ArrayList<TraitModifier>(this.traitModifiers.values());
        for (StatModifier statMod : this.statModifiers.values()) {
            if (statMod.stat() == null || !statMod.stat().hasDirectTrait() || !trait.equals(statMod.stat().getTraits().get(0)) || statMod.operation() != AuraSkillsModifier.Operation.MULTIPLY && statMod.operation() != AuraSkillsModifier.Operation.ADD_PERCENT) continue;
            modifiers.add((TraitModifier)((Object)statMod));
        }
        level = this.calculateModifiers(level, modifiers, trait);
        return level;
    }

    @Nullable
    public TraitModifier getTraitModifier(String name) {
        return this.traitModifiers.get(name);
    }

    public Map<String, TraitModifier> getTraitModifiers() {
        return this.traitModifiers;
    }

    public void addTraitModifier(TraitModifier modifier, boolean reload) {
        this.addModifier(modifier, reload, this.traitModifiers);
    }

    public void addTemporaryTraitModifier(TraitModifier modifier, boolean reload, long expirationTime) {
        if (!modifier.isTemporary()) {
            throw new IllegalArgumentException("Trait modifier is not a temporary trait modifier");
        }
        this.addModifier(modifier, reload, this.traitModifiers);
        this.tempModExpiryQueue.add(new TemporaryModifier(modifier, expirationTime));
    }

    public boolean removeTraitModifier(String name, boolean reload) {
        return this.removeModifier(name, reload, this.traitModifiers);
    }

    private <T extends AuraSkillsModifier<V>, V extends ReloadableIdentifier> void addModifier(T modifier, boolean reload, Map<String, T> map) {
        if (map.containsKey(modifier.name())) {
            AuraSkillsModifier oldModifier = (AuraSkillsModifier)map.get(modifier.name());
            if (oldModifier.equals(modifier)) {
                return;
            }
            this.removeModifier(modifier.name(), false, map);
        }
        map.put(modifier.name(), modifier);
        if (modifier instanceof StatModifier) {
            StatModifier statModifier = (StatModifier)modifier;
            this.recalculateStat(statModifier.stat());
        }
        if (reload) {
            this.plugin.getStatManager().reload(this.user, modifier.type());
        }
    }

    private <T extends AuraSkillsModifier<V>, V extends ReloadableIdentifier> boolean removeModifier(String name, boolean reload, Map<String, T> map) {
        AuraSkillsModifier modifier = (AuraSkillsModifier)map.get(name);
        if (modifier == null) {
            return false;
        }
        map.remove(name);
        if (modifier instanceof StatModifier) {
            StatModifier statModifier = (StatModifier)modifier;
            this.recalculateStat(statModifier.stat());
        }
        if (reload) {
            this.plugin.getStatManager().reload(this.user, modifier.type());
        }
        return true;
    }

    public void recalculateStat(Stat stat) {
        double base = this.calculateRewardsStat(stat);
        double level = this.calculateModifiers(base, this.statModifiers.values(), stat);
        this.statLevels.put(stat, level);
        this.baseStatLevels.put(stat, base);
    }

    private <T> double calculateModifiers(double base, Collection<? extends AuraSkillsModifier<?>> modifiers, T filter) {
        Stat stat;
        double addModSum = 0.0;
        double multiplyModProduct = 1.0;
        double addPercentSum = 0.0;
        boolean skipPercents = filter instanceof Stat && (stat = (Stat)filter).hasDirectTrait();
        for (AuraSkillsModifier<?> modifier : modifiers) {
            Stat stat2;
            Object obj;
            if (!modifier.type().equals(filter) && (!((obj = modifier.type()) instanceof Stat) || !(stat2 = (Stat)obj).hasDirectTrait() || !filter.equals(stat2.getTraits().get(0)))) continue;
            switch (modifier.operation()) {
                case ADD: {
                    addModSum += modifier.value();
                    break;
                }
                case MULTIPLY: {
                    if (skipPercents) break;
                    multiplyModProduct *= modifier.value();
                    break;
                }
                case ADD_PERCENT: {
                    if (skipPercents) break;
                    addPercentSum += modifier.value();
                }
            }
        }
        return (base + addModSum) * multiplyModProduct * (1.0 + addPercentSum / 100.0);
    }

    private double getTraitLevelFromStats(Trait trait, double base) {
        for (Stat stat : this.plugin.getTraitManager().getLinkedStats(trait)) {
            base += this.getStatLevel(stat) * stat.getTraitModifier(trait);
        }
        return base;
    }

    public double getStatBaseAddSum(Stat stat) {
        double base = this.getBaseStatLevel(stat);
        for (StatModifier modifier : this.statModifiers.values()) {
            if (!modifier.stat().equals(stat) || modifier.operation() != AuraSkillsModifier.Operation.ADD) continue;
            base += modifier.value();
        }
        return base;
    }

    public double getTraitBaseAddSum(Trait trait) {
        double base = this.plugin.getTraitManager().getBaseLevel(this.user, trait);
        base = this.getTraitLevelFromStats(trait, base);
        for (TraitModifier modifier : this.traitModifiers.values()) {
            if (!modifier.trait().equals(trait) || modifier.operation() != AuraSkillsModifier.Operation.ADD) continue;
            base += modifier.value();
        }
        return base;
    }

    public double getStatAddPercentSum(Stat stat) {
        double sum = 0.0;
        for (StatModifier modifier : this.statModifiers.values()) {
            if (!modifier.stat().equals(stat) || modifier.operation() != AuraSkillsModifier.Operation.ADD_PERCENT) continue;
            sum += modifier.value();
        }
        return sum;
    }

    public double getTraitAddPercentSum(Trait trait) {
        double sum = 0.0;
        for (TraitModifier modifier : this.traitModifiers.values()) {
            if (!modifier.trait().equals(trait) || modifier.operation() != AuraSkillsModifier.Operation.ADD_PERCENT) continue;
            sum += modifier.value();
        }
        return sum;
    }

    public double getStatMultiplyProduct(Stat stat) {
        double prod = 1.0;
        for (StatModifier modifier : this.statModifiers.values()) {
            if (!modifier.stat().equals(stat) || modifier.operation() != AuraSkillsModifier.Operation.MULTIPLY) continue;
            prod *= modifier.value();
        }
        return prod;
    }

    public double getTraitMultiplyProduct(Trait trait) {
        double prod = 1.0;
        for (TraitModifier modifier : this.traitModifiers.values()) {
            if (!modifier.trait().equals(trait) || modifier.operation() != AuraSkillsModifier.Operation.MULTIPLY) continue;
            prod *= modifier.value();
        }
        return prod;
    }

    public double calculateRewardsStat(Stat stat) {
        double level = 0.0;
        for (Skill skill : this.plugin.getSkillManager().getEnabledSkills()) {
            if (!this.user.hasSkillPermission(skill)) continue;
            for (Map.Entry<Stat, Double> entry : this.getStatLevelRewards(stat, skill)) {
                level += entry.getValue().doubleValue();
            }
        }
        return level;
    }

    public Map<Skill, Double> getLevelRewardedBySkill(Stat stat) {
        ConcurrentHashMap<Skill, Double> map = new ConcurrentHashMap<Skill, Double>();
        for (Skill skill : this.plugin.getSkillManager().getEnabledSkills()) {
            double sum = 0.0;
            for (Map.Entry<Stat, Double> entry : this.getStatLevelRewards(stat, skill)) {
                sum += entry.getValue().doubleValue();
            }
            if (!(sum > 0.0)) continue;
            map.put(skill, sum);
        }
        return map;
    }

    private List<Map.Entry<Stat, Double>> getStatLevelRewards(Stat stat, Skill skill) {
        ArrayList<Map.Entry<Stat, Double>> entries = new ArrayList<Map.Entry<Stat, Double>>();
        Map<Stat, Double> skillRewardedStats = this.plugin.getRewardManager().getRewardTable(skill).getStatLevels(this.user.getSkillLevel(skill));
        for (Map.Entry<Stat, Double> entry : skillRewardedStats.entrySet()) {
            if (!entry.getKey().equals(stat)) continue;
            entries.add(entry);
        }
        return entries;
    }
}

