/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.storage.sql.pool;

import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.storage.sql.DatabaseCredentials;
import dev.aurelium.auraskills.hikari.HikariConfig;
import dev.aurelium.auraskills.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;

public abstract class ConnectionPool {
    private final AuraSkillsPlugin plugin;
    private final DatabaseCredentials credentials;
    private HikariDataSource dataSource;

    public ConnectionPool(AuraSkillsPlugin plugin, DatabaseCredentials credentials) {
        this.plugin = plugin;
        this.credentials = credentials;
    }

    public String getDatabaseName() {
        return this.credentials.database();
    }

    public abstract void configure(HikariConfig var1, DatabaseCredentials var2);

    public void enable() {
        HikariConfig config = new HikariConfig();
        config.addDataSourceProperty("socketTimeout", String.valueOf(TimeUnit.SECONDS.toMillis(30L)));
        config.setPoolName("auraskills-hikari");
        config.setMaximumPoolSize(this.plugin.configInt(Option.SQL_POOL_MAXIMUM_POOL_SIZE));
        config.setMinimumIdle(this.plugin.configInt(Option.SQL_POOL_MINIMUM_IDLE));
        config.setConnectionTimeout(this.plugin.configInt(Option.SQL_POOL_CONNECTION_TIMEOUT));
        config.setMaxLifetime(this.plugin.configInt(Option.SQL_POOL_MAX_LIFETIME));
        config.setKeepaliveTime(this.plugin.configInt(Option.SQL_POOL_KEEPALIVE_TIME));
        this.configure(config, this.credentials);
        this.dataSource = new HikariDataSource(config);
    }

    public void disable() {
        if (this.dataSource != null) {
            this.dataSource.close();
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.dataSource == null) {
            throw new SQLException("Failed to get a connection from the pool (dataSource is null).");
        }
        Connection connection = this.dataSource.getConnection();
        if (connection == null) {
            throw new SQLException("Failed to get a connection from the pool (getConnection returned null).");
        }
        return connection;
    }
}

