/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.storage.sql;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.aurelium.auraskills.api.ability.AbstractAbility;
import dev.aurelium.auraskills.api.mana.ManaAbility;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.stat.StatModifier;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.trait.TraitModifier;
import dev.aurelium.auraskills.api.util.AuraSkillsModifier;
import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.ui.ActionBarType;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.data.KeyIntPair;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlUserLoader {
    private final AuraSkillsPlugin plugin;
    private static final String LOAD_QUERY = "SELECT u.*,\n    (\n        SELECT JSON_ARRAYAGG(JSON_OBJECT(\n            'name', s.skill_name,\n            'level', s.skill_level,\n            'xp', s.skill_xp\n        ))\n        FROM auraskills_skill_levels s\n        WHERE s.user_id = u.user_id\n    ) AS skill_levels,\n    (\n        SELECT JSON_ARRAYAGG(JSON_OBJECT(\n            'data_id', k.data_id,\n            'category_id', k.category_id,\n            'key_name', k.key_name,\n            'value', k.value\n        ))\n        FROM auraskills_key_values k\n        WHERE k.user_id = u.user_id\n    ) AS key_values,\n    (\n        SELECT JSON_ARRAYAGG(JSON_OBJECT(\n            'modifier_type', m.modifier_type,\n            'type_id', m.type_id,\n            'modifier_name', m.modifier_name,\n            'modifier_value', m.modifier_value,\n            'modifier_operation', m.modifier_operation,\n            'expiration_time', m.expiration_time,\n            'remaining_duration', m.remaining_duration\n        ))\n        FROM auraskills_modifiers m\n        WHERE m.user_id = u.user_id\n    ) AS modifiers\nFROM\n    auraskills_users u\nWHERE\n    u.player_uuid = ?;\n";

    public SqlUserLoader(AuraSkillsPlugin plugin) {
        this.plugin = plugin;
    }

    public void loadUser(UUID uuid, User user, Connection connection) {
        try (PreparedStatement statement = connection.prepareStatement(LOAD_QUERY);){
            statement.setString(1, uuid.toString());
            try (ResultSet rs = statement.executeQuery();){
                if (!rs.next()) {
                    return;
                }
                this.processResultSet(rs, user);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void processResultSet(ResultSet rs, User user) throws SQLException {
        JsonArray modifiers;
        JsonArray keyValues;
        String localeString = rs.getString("locale");
        if (localeString != null) {
            localeString = localeString.replace("_", "-");
            user.setLocale(Locale.forLanguageTag(localeString));
        }
        double mana = rs.getDouble("mana");
        user.setMana(mana);
        JsonArray skillLevels = this.getJsonArray("skill_levels", rs);
        if (skillLevels != null) {
            for (Object skillLevelElement : skillLevels) {
                JsonObject skillLevelObj = skillLevelElement.getAsJsonObject();
                String name = this.getString(skillLevelObj, "name");
                int level = skillLevelObj.get("level").getAsInt();
                double xp = skillLevelObj.get("xp").getAsDouble();
                Skill skill = (Skill)this.plugin.getSkillRegistry().getOrNull(NamespacedId.fromString(name));
                if (skill == null) continue;
                user.setSkillLevel(skill, level);
                user.setSkillXp(skill, xp);
            }
        }
        if ((keyValues = this.getJsonArray("key_values", rs)) != null && !keyValues.isJsonNull()) {
            for (JsonElement keyValueElement : keyValues) {
                JsonObject keyValueObj = keyValueElement.getAsJsonObject();
                int dataId = keyValueObj.get("data_id").getAsInt();
                String categoryId = this.getString(keyValueObj, "category_id");
                String keyName = this.getString(keyValueObj, "key_name");
                if (keyName == null) continue;
                String value = this.getString(keyValueObj, "value");
                switch (dataId) {
                    case 3: {
                        this.applyAbilityData(user, categoryId, keyName, value);
                        break;
                    }
                    case 4: {
                        this.applyUnclaimedItem(user, keyName, value);
                        break;
                    }
                    case 5: {
                        this.applyActionBar(user, keyName, value);
                        break;
                    }
                    case 6: {
                        this.applyJobs(user, keyName, value);
                    }
                }
            }
        }
        if ((modifiers = this.getJsonArray("modifiers", rs)) != null && !modifiers.isJsonNull()) {
            for (JsonElement modifierElement : modifiers) {
                this.applyModifier(user, modifierElement);
            }
        }
        user.clearInvalidItems();
    }

    private void applyModifier(User user, JsonElement modifierElement) {
        JsonObject modifierObj = modifierElement.getAsJsonObject();
        String modifierType = this.getString(modifierObj, "modifier_type");
        String typeId = this.getString(modifierObj, "type_id");
        if (typeId.isEmpty()) {
            return;
        }
        String name = this.getString(modifierObj, "modifier_name");
        double value = this.getDouble(modifierObj, "modifier_value");
        byte operationVal = this.getByte(modifierObj, "modifier_operation");
        AuraSkillsModifier.Operation operation = AuraSkillsModifier.Operation.fromSqlId(operationVal);
        long expirationTime = this.getLong(modifierObj, "expiration_time");
        long remainingDuration = this.getLong(modifierObj, "remaining_duration");
        boolean pauseOffline = false;
        if (remainingDuration != 0L) {
            expirationTime = System.currentTimeMillis() + remainingDuration;
            pauseOffline = true;
        }
        if (modifierType.equals("stat")) {
            Stat stat = (Stat)this.plugin.getStatRegistry().getOrNull(NamespacedId.fromString(typeId));
            if (stat == null) {
                return;
            }
            StatModifier modifier = new StatModifier(name, stat, value, operation);
            if (expirationTime != 0L) {
                modifier.makeTemporary(expirationTime, pauseOffline);
                user.getUserStats().addTemporaryStatModifier(modifier, false, expirationTime);
            } else {
                user.addStatModifier(modifier, false);
            }
        } else if (modifierType.equals("trait")) {
            Trait trait = (Trait)this.plugin.getTraitRegistry().getOrNull(NamespacedId.fromString(typeId));
            if (trait == null) {
                return;
            }
            TraitModifier modifier = new TraitModifier(name, trait, value, operation);
            if (expirationTime != 0L) {
                modifier.makeTemporary(expirationTime, pauseOffline);
                user.getUserStats().addTemporaryTraitModifier(modifier, false, expirationTime);
            } else {
                user.addTraitModifier(modifier, false);
            }
        }
    }

    private void applyAbilityData(User user, String categoryId, String keyName, String valueStr) {
        AbstractAbility ability = this.plugin.getAbilityManager().getAbstractAbility(NamespacedId.fromString(categoryId));
        if (ability == null) {
            return;
        }
        Object parsed = this.castValue(valueStr);
        if (keyName.equals("cooldown") && ability instanceof ManaAbility) {
            ManaAbility manaAbility = (ManaAbility)ability;
            user.getManaAbilityData(manaAbility).setCooldown(NumberUtil.toInt(valueStr));
        } else {
            user.getAbilityData(ability).setData(keyName, parsed);
        }
    }

    private void applyUnclaimedItem(User user, String keyName, String valueStr) {
        KeyIntPair pair = new KeyIntPair(keyName, NumberUtil.toInt(valueStr, 1));
        user.getUnclaimedItems().add(pair);
    }

    private void applyActionBar(User user, String keyName, String valueStr) {
        try {
            ActionBarType type = ActionBarType.valueOf(keyName.toUpperCase(Locale.ROOT));
            boolean enabled = !valueStr.equals("false");
            user.setActionBarSetting(type, enabled);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void applyJobs(User user, String keyName, String valueStr) {
        if (keyName.equals("jobs")) {
            String[] splitValue;
            user.clearAllJobs();
            for (String skillName : splitValue = valueStr.split(",")) {
                if (skillName.isEmpty()) continue;
                NamespacedId id = NamespacedId.fromString(skillName);
                Skill skill = (Skill)this.plugin.getSkillRegistry().getOrNull(id);
                if (skill == null || !user.canSelectJob(skill)) continue;
                user.addJob(skill);
            }
        } else if (keyName.equals("last_select_time")) {
            long time;
            try {
                time = Long.parseLong(valueStr);
            }
            catch (NumberFormatException e) {
                time = 0L;
            }
            user.setLastJobSelectTime(time);
        }
    }

    @Nullable
    private JsonArray getJsonArray(String name, ResultSet rs) throws SQLException {
        String raw = rs.getString(name);
        if (raw == null) {
            return null;
        }
        return JsonParser.parseString((String)raw).getAsJsonArray();
    }

    @NotNull
    private Object castValue(String value) {
        Object parsed = value;
        if (value.equals("true")) {
            parsed = true;
        } else if (value.equals("false")) {
            parsed = false;
        } else {
            try {
                parsed = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                try {
                    parsed = Double.parseDouble(value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return parsed;
    }

    private String getString(JsonObject parent, String key) {
        JsonElement element = parent.get(key);
        if (element != null && !element.isJsonNull() && element.isJsonPrimitive()) {
            return element.getAsString();
        }
        return "";
    }

    private long getLong(JsonObject parent, String key) {
        JsonElement element = parent.get(key);
        if (element != null && !element.isJsonNull() && element.isJsonPrimitive()) {
            return element.getAsLong();
        }
        return 0L;
    }

    private double getDouble(JsonObject parent, String key) {
        JsonElement element = parent.get(key);
        if (element != null && !element.isJsonNull() && element.isJsonPrimitive()) {
            return element.getAsDouble();
        }
        return 0.0;
    }

    private byte getByte(JsonObject parent, String key) {
        JsonElement element = parent.get(key);
        if (element != null && !element.isJsonNull() && element.isJsonPrimitive()) {
            return element.getAsByte();
        }
        return 0;
    }
}

