/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.storage.sql;

import dev.aurelium.auraskills.api.ability.AbstractAbility;
import dev.aurelium.auraskills.api.mana.ManaAbility;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.stat.StatModifier;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.trait.TraitModifier;
import dev.aurelium.auraskills.api.util.AuraSkillsModifier;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.ability.AbilityData;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.mana.ManaAbilityData;
import dev.aurelium.auraskills.common.ref.PlayerRef;
import dev.aurelium.auraskills.common.region.BlockPosition;
import dev.aurelium.auraskills.common.storage.StorageProvider;
import dev.aurelium.auraskills.common.storage.sql.KeyValueRow;
import dev.aurelium.auraskills.common.storage.sql.ModifierRow;
import dev.aurelium.auraskills.common.storage.sql.SqlUserLoader;
import dev.aurelium.auraskills.common.storage.sql.TableCreator;
import dev.aurelium.auraskills.common.storage.sql.migration.SqlMigrator;
import dev.aurelium.auraskills.common.storage.sql.pool.ConnectionPool;
import dev.aurelium.auraskills.common.ui.ActionBarType;
import dev.aurelium.auraskills.common.user.AntiAfkLog;
import dev.aurelium.auraskills.common.user.SkillLevelMaps;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.user.UserState;
import dev.aurelium.auraskills.common.util.data.KeyIntPair;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlStorageProvider
extends StorageProvider {
    private final ConnectionPool pool;
    private final SqlUserLoader userLoader;
    public static final String TABLE_PREFIX = "auraskills_";
    public static final int STAT_MODIFIER_ID = 1;
    public static final int ABILITY_DATA_ID = 3;
    public static final int UNCLAIMED_ITEMS_ID = 4;
    public static final int ACTION_BAR_ID = 5;
    public static final int JOBS_ID = 6;
    public static final String MODIFIER_TYPE_STAT = "stat";
    public static final String MODIFIER_TYPE_TRAIT = "trait";
    public static final String LOG_TYPE_ANTI_AFK = "anti_afk";
    public static final int LOG_LEVEL_WARN = 2;
    public static final String JOBS_LAST_SELECT_TIME = "last_select_time";

    public SqlStorageProvider(AuraSkillsPlugin plugin, ConnectionPool pool) {
        super(plugin);
        this.pool = pool;
        this.userLoader = new SqlUserLoader(plugin);
        this.attemptTableCreation();
        try {
            SqlMigrator migrator = new SqlMigrator(plugin, pool);
            migrator.runMigrations();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to migrate SQL tables. Please report this!", e);
        }
    }

    public ConnectionPool getPool() {
        return this.pool;
    }

    public void attemptTableCreation() {
        TableCreator tableCreator = new TableCreator(this.plugin, this.pool, TABLE_PREFIX);
        tableCreator.createTables();
    }

    @Override
    protected User loadRaw(UUID uuid, @Nullable PlayerRef platformPlayer) throws Exception {
        try (Connection connection = this.pool.getConnection();){
            User user = this.userManager.createNewUser(uuid, platformPlayer);
            this.userLoader.loadUser(uuid, user, connection);
            User user2 = user;
            return user2;
        }
    }

    private SkillLevelMaps loadSkillLevels(Connection connection, UUID uuid, int userId) throws SQLException {
        ConcurrentHashMap<Skill, Double> xpMap;
        ConcurrentHashMap<Skill, Integer> levelsMap;
        block16: {
            levelsMap = new ConcurrentHashMap<Skill, Integer>();
            xpMap = new ConcurrentHashMap<Skill, Double>();
            String loadQuery = "SELECT * FROM auraskills_skill_levels WHERE user_id=?";
            try (PreparedStatement statement = connection.prepareStatement(loadQuery);){
                statement.setInt(1, userId);
                ResultSet resultSet = statement.executeQuery();
                block12: while (true) {
                    while (resultSet.next()) {
                        String skillName = resultSet.getString("skill_name");
                        NamespacedId skillId = NamespacedId.fromString(skillName);
                        try {
                            Skill skill = (Skill)this.plugin.getSkillRegistry().get(skillId);
                            int level = resultSet.getInt("skill_level");
                            double xp = resultSet.getDouble("skill_xp");
                            levelsMap.put(skill, level);
                            xpMap.put(skill, xp);
                            continue block12;
                        }
                        catch (IllegalArgumentException e) {
                            this.plugin.logger().warn("Failed to load skill level for player " + String.valueOf(uuid) + " because " + skillName + " is not a registered skill");
                        }
                    }
                    break block16;
                    {
                        continue block12;
                        break;
                    }
                    break;
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
        }
        return new SkillLevelMaps(levelsMap, xpMap);
    }

    private Map<String, StatModifier> loadStatModifiers(Connection connection, UUID uuid, int userId) throws SQLException {
        ConcurrentHashMap<String, StatModifier> modifiers = new ConcurrentHashMap<String, StatModifier>();
        String query = "SELECT type_id, modifier_name, modifier_value, modifier_operation, expiration_time, remaining_duration FROM auraskills_modifiers WHERE user_id=? AND modifier_type=?";
        try (PreparedStatement statement = connection.prepareStatement(query);){
            statement.setInt(1, userId);
            statement.setString(2, MODIFIER_TYPE_STAT);
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    String typeId = resultSet.getString("type_id");
                    if (typeId == null) continue;
                    Stat stat = (Stat)this.plugin.getStatRegistry().getOrNull(NamespacedId.fromString(typeId));
                    if (stat == null) {
                        this.plugin.logger().warn("Failed to load stat modifier for player " + String.valueOf(uuid) + " because " + typeId + " is not a registered stat");
                        continue;
                    }
                    String modifierName = resultSet.getString("modifier_name");
                    double value = resultSet.getDouble("modifier_value");
                    AuraSkillsModifier.Operation operation = AuraSkillsModifier.Operation.fromSqlId(resultSet.getByte("modifier_operation"));
                    StatModifier modifier = new StatModifier(modifierName, stat, value, operation);
                    this.loadTemporary(resultSet, modifier);
                    modifiers.put(modifierName, modifier);
                }
            }
        }
        return modifiers;
    }

    private Map<String, TraitModifier> loadTraitModifiers(Connection connection, UUID uuid, int userId) throws SQLException {
        ConcurrentHashMap<String, TraitModifier> modifiers = new ConcurrentHashMap<String, TraitModifier>();
        String query = "SELECT type_id, modifier_name, modifier_value, modifier_operation, expiration_time, remaining_duration FROM auraskills_modifiers WHERE user_id=? AND modifier_type=?";
        try (PreparedStatement statement = connection.prepareStatement(query);){
            statement.setInt(1, userId);
            statement.setString(2, MODIFIER_TYPE_TRAIT);
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    String typeId = resultSet.getString("type_id");
                    if (typeId == null) continue;
                    Trait trait = (Trait)this.plugin.getTraitRegistry().getOrNull(NamespacedId.fromString(typeId));
                    if (trait == null) {
                        this.plugin.logger().warn("Failed to load trait modifier for player " + String.valueOf(uuid) + " because " + typeId + " is not a registered trait");
                        continue;
                    }
                    String modifierName = resultSet.getString("modifier_name");
                    double value = resultSet.getDouble("modifier_value");
                    AuraSkillsModifier.Operation operation = AuraSkillsModifier.Operation.fromSqlId(resultSet.getByte("modifier_operation"));
                    TraitModifier modifier = new TraitModifier(modifierName, trait, value, operation);
                    this.loadTemporary(resultSet, modifier);
                    modifiers.put(modifierName, modifier);
                }
            }
        }
        return modifiers;
    }

    private void loadTemporary(ResultSet resultSet, AuraSkillsModifier<?> modifier) throws SQLException {
        long expirationTime = resultSet.getLong("expiration_time");
        long remainingDuration = resultSet.getLong("remaining_duration");
        boolean pauseOffline = false;
        if (remainingDuration != 0L) {
            expirationTime = System.currentTimeMillis() + remainingDuration;
            pauseOffline = true;
        }
        if (expirationTime != 0L) {
            modifier.makeTemporary(expirationTime, pauseOffline);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    @NotNull
    public UserState loadState(UUID uuid) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void applyState(UserState state) throws Exception {
        String usersQuery = "INSERT INTO auraskills_users (player_uuid, mana) VALUES (?, ?) ON DUPLICATE KEY UPDATE mana = ?, last_updated = CURRENT_TIMESTAMP";
        try (Connection connection = this.pool.getConnection();){
            try (PreparedStatement statement = connection.prepareStatement(usersQuery);){
                statement.setString(1, state.uuid().toString());
                statement.setDouble(2, state.mana());
                statement.setDouble(3, state.mana());
                statement.executeUpdate();
            }
            int userId = this.getUserId(connection, state.uuid());
            String skillLevelsQuery = "INSERT INTO auraskills_skill_levels (user_id, skill_name, skill_level, skill_xp) VALUES (?, ?, ?, ?) ON DUPLICATE KEY UPDATE skill_level=?, skill_xp=?";
            try (PreparedStatement statement = connection.prepareStatement(skillLevelsQuery);){
                statement.setInt(1, userId);
                for (Map.Entry<Skill, Integer> entry : state.skillLevels().entrySet()) {
                    String skillName = entry.getKey().getId().toString();
                    int level = entry.getValue();
                    double xp = state.skillXp().get(entry.getKey());
                    statement.setString(2, skillName);
                    statement.setInt(3, level);
                    statement.setDouble(4, xp);
                    statement.setInt(5, level);
                    statement.setDouble(6, xp);
                    statement.executeUpdate();
                }
            }
            ConcurrentHashMap modifiers = new ConcurrentHashMap();
            modifiers.putAll(state.statModifiers());
            modifiers.putAll(state.traitModifiers());
            this.saveModifierRows(connection, userId, this.getModifierRows(modifiers));
        }
    }

    public int getUserId(Connection connection, UUID uuid) throws SQLException {
        String query = "SELECT user_id FROM auraskills_users WHERE player_uuid=?";
        try (PreparedStatement statement = connection.prepareStatement(query);){
            statement.setString(1, uuid.toString());
            try (ResultSet resultSet = statement.executeQuery();){
                if (resultSet.next()) {
                    int n = resultSet.getInt("user_id");
                    return n;
                }
                throw new RuntimeException("Failed to get user_id for player " + String.valueOf(uuid));
            }
        }
    }

    @Override
    public void save(@NotNull User user) throws Exception {
        if (user.shouldNotSave()) {
            return;
        }
        if (!this.plugin.configBoolean(Option.SAVE_BLANK_PROFILES) && user.isBlankProfile()) {
            try (Connection connection = this.pool.getConnection();){
                this.deleteUser(connection, user);
                connection.setAutoCommit(true);
            }
            catch (SQLException e) {
                this.plugin.logger().severe("Error deleting blank profile of user with UUID " + String.valueOf(user.getUuid()));
                throw e;
            }
            return;
        }
        try (Connection connection = this.pool.getConnection();){
            connection.setAutoCommit(false);
            this.saveUsersTable(connection, user);
            this.saveSkillLevelsTable(connection, user);
            int userId = this.getUserId(connection, user.getUuid());
            this.saveKeyValuesTable(connection, user, userId);
            this.saveModifiersTable(connection, user, userId);
            this.saveLogsTable(connection, user);
            connection.commit();
            connection.setAutoCommit(true);
        }
    }

    private void saveUsersTable(Connection connection, User user) throws SQLException {
        String usersQuery = "INSERT INTO auraskills_users (player_uuid, locale, mana) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE locale = ?, mana = ?, last_updated = CURRENT_TIMESTAMP";
        try (PreparedStatement statement = connection.prepareStatement(usersQuery);){
            statement.setString(1, user.getUuid().toString());
            int curr = 2;
            for (int i = 0; i < 2; ++i) {
                if (user.hasLocale()) {
                    statement.setString(curr++, user.getLocale().toLanguageTag());
                } else {
                    statement.setNull(curr++, 12);
                }
                statement.setDouble(curr++, user.getMana());
            }
            statement.executeUpdate();
        }
    }

    private void saveSkillLevelsTable(Connection connection, User user) throws SQLException {
        int userId = this.getUserId(connection, user.getUuid());
        String skillLevelsQuery = "INSERT INTO auraskills_skill_levels (user_id, skill_name, skill_level, skill_xp) VALUES (?, ?, ?, ?) ON DUPLICATE KEY UPDATE skill_level=?, skill_xp=?";
        try (PreparedStatement statement = connection.prepareStatement(skillLevelsQuery);){
            statement.setInt(1, userId);
            for (Map.Entry<Skill, Integer> entry : user.getSkillLevelMap().entrySet()) {
                String skillName = entry.getKey().getId().toString();
                int level = entry.getValue();
                double xp = user.getSkillXpMap().get(entry.getKey());
                statement.setString(2, skillName);
                statement.setInt(3, level);
                statement.setDouble(4, xp);
                statement.setInt(5, level);
                statement.setDouble(6, xp);
                statement.executeUpdate();
            }
        }
    }

    private void saveKeyValuesTable(Connection connection, User user, int userId) throws SQLException {
        this.deleteKeyValues(connection, userId);
        ArrayList<KeyValueRow> rows = new ArrayList<KeyValueRow>();
        rows.addAll(this.getAbilityDataRows(user.getAbilityDataMap(), user.getManaAbilityDataMap()));
        rows.addAll(this.getUnclaimedItemsRow(user.getUnclaimedItems()));
        rows.addAll(this.getActionBarRow(user));
        rows.addAll(this.getJobsRow(user, user.getJobs()));
        this.saveKeyValueRows(connection, userId, rows);
    }

    private void saveModifiersTable(Connection connection, User user, int userId) throws SQLException {
        this.deleteModifiers(connection, userId);
        ConcurrentHashMap modifiers = new ConcurrentHashMap();
        modifiers.putAll(user.getStatModifiers());
        modifiers.putAll(user.getTraitModifiers());
        List<ModifierRow> rows = this.getModifierRows(modifiers);
        this.saveModifierRows(connection, userId, rows);
    }

    private void saveLogsTable(Connection connection, User user) throws SQLException {
        this.saveAntiAfkLogs(user.getSessionAntiAfkLogs(), connection, user);
    }

    private void saveKeyValueRows(Connection connection, int userId, List<KeyValueRow> rows) throws SQLException {
        String query = "INSERT INTO auraskills_key_values (user_id, data_id, category_id, key_name, value) VALUES (?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE value=?";
        try (PreparedStatement ps = connection.prepareStatement("INSERT INTO auraskills_key_values (user_id, data_id, category_id, key_name, value) VALUES (?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE value=?");){
            for (KeyValueRow row : rows) {
                ps.setInt(1, userId);
                ps.setInt(2, row.dataId());
                ps.setString(3, row.categoryId());
                ps.setString(4, row.keyName());
                ps.setString(5, row.value());
                ps.setString(6, row.value());
                ps.addBatch();
            }
            ps.executeBatch();
        }
    }

    private void saveModifierRows(Connection connection, int userId, List<ModifierRow> rows) throws SQLException {
        String sql = "INSERT INTO auraskills_modifiers (\n    user_id,\n    modifier_type,\n    type_id,\n    modifier_name,\n    modifier_value,\n    modifier_operation,\n    expiration_time,\n    remaining_duration,\n    metadata\n) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)\nON DUPLICATE KEY UPDATE\n    modifier_value = VALUES(modifier_value),\n    expiration_time = VALUES(expiration_time),\n    remaining_duration = VALUES(remaining_duration),\n    metadata = VALUES(metadata)\n";
        try (PreparedStatement ps = connection.prepareStatement(sql);){
            for (ModifierRow row : rows) {
                ps.setInt(1, userId);
                ps.setString(2, row.modifierType());
                if (row.typeId() != null) {
                    ps.setString(3, row.typeId());
                } else {
                    ps.setNull(3, 12);
                }
                ps.setString(4, row.modifierName());
                ps.setDouble(5, row.modifierValue());
                ps.setByte(6, row.modifierOperation());
                ps.setLong(7, row.expirationTime());
                ps.setLong(8, row.remainingDuration());
                if (row.metadata() != null) {
                    ps.setString(9, row.metadata());
                } else {
                    ps.setNull(9, -1);
                }
                ps.addBatch();
            }
            ps.executeBatch();
        }
    }

    private void deleteUser(Connection connection, User user) throws SQLException {
        block25: {
            connection.setAutoCommit(false);
            String getUserIdQuery = "SELECT user_id FROM auraskills_users WHERE player_uuid=?";
            try (PreparedStatement statement = connection.prepareStatement(getUserIdQuery);){
                statement.setString(1, user.getUuid().toString());
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        int userId = rs.getInt("user_id");
                        String deleteKeyValuesQuery = "DELETE FROM auraskills_key_values WHERE user_id=?;";
                        try (PreparedStatement delStatement = connection.prepareStatement(deleteKeyValuesQuery);){
                            delStatement.setInt(1, userId);
                            delStatement.executeUpdate();
                        }
                        this.deleteSkillLevelsUsers(connection, userId);
                        connection.commit();
                        break block25;
                    }
                    connection.rollback();
                }
            }
            catch (SQLException e) {
                connection.rollback();
                throw e;
            }
            finally {
                connection.setAutoCommit(true);
            }
        }
    }

    private void deleteSkillLevelsUsers(Connection connection, int userId) throws SQLException {
        String deleteSkillLevelsQuery = "DELETE FROM auraskills_skill_levels WHERE user_id=?;";
        try (PreparedStatement delStatement = connection.prepareStatement(deleteSkillLevelsQuery);){
            delStatement.setInt(1, userId);
            delStatement.executeUpdate();
        }
        String deleteUsersQuery = "DELETE FROM auraskills_users WHERE user_id=?;";
        try (PreparedStatement delStatement = connection.prepareStatement(deleteUsersQuery);){
            delStatement.setInt(1, userId);
            delStatement.executeUpdate();
        }
    }

    private void deleteKeyValues(Connection connection, int userId) throws SQLException {
        String query = "DELETE FROM auraskills_key_values WHERE user_id=?";
        try (PreparedStatement statement = connection.prepareStatement(query);){
            statement.setInt(1, userId);
            statement.executeUpdate();
        }
    }

    private void deleteModifiers(Connection connection, int userId) throws SQLException {
        String query = "DELETE FROM auraskills_modifiers WHERE user_id=?";
        try (PreparedStatement statement = connection.prepareStatement(query);){
            statement.setInt(1, userId);
            statement.executeUpdate();
        }
    }

    private List<ModifierRow> getModifierRows(Map<String, AuraSkillsModifier<?>> modifiers) {
        ArrayList<ModifierRow> rows = new ArrayList<ModifierRow>();
        if (modifiers.isEmpty()) {
            return rows;
        }
        for (AuraSkillsModifier<?> modifier : modifiers.values()) {
            if (modifier.isNonPersistent()) continue;
            String statId = modifier.type().getId().toString();
            byte operationId = modifier.operation().getSqlId();
            long expTime = modifier.getExpirationTime();
            long remainingDuration = 0L;
            if (modifier.isTemporary() && modifier.isPauseOffline()) {
                remainingDuration = modifier.getExpirationTime() - System.currentTimeMillis();
            }
            ModifierRow row = new ModifierRow(modifier instanceof StatModifier ? MODIFIER_TYPE_STAT : MODIFIER_TYPE_TRAIT, statId, modifier.name(), modifier.value(), operationId, expTime, remainingDuration, null);
            rows.add(row);
        }
        return rows;
    }

    private List<KeyValueRow> getAbilityDataRows(Map<AbstractAbility, AbilityData> abilityDataMap, Map<ManaAbility, ManaAbilityData> manaAbilityDataMap) {
        String categoryId;
        ArrayList<KeyValueRow> rows = new ArrayList<KeyValueRow>();
        if (abilityDataMap.isEmpty()) {
            return rows;
        }
        for (AbilityData abilityData : abilityDataMap.values()) {
            categoryId = abilityData.getAbility().getId().toString();
            for (Map.Entry<String, Object> dataEntry : abilityData.getDataMap().entrySet()) {
                KeyValueRow row = new KeyValueRow(3, categoryId, dataEntry.getKey(), String.valueOf(dataEntry.getValue()));
                rows.add(row);
            }
        }
        for (ManaAbilityData data : manaAbilityDataMap.values()) {
            if (data.getCooldown() <= 0) continue;
            categoryId = data.getManaAbility().getId().toString();
            KeyValueRow row = new KeyValueRow(3, categoryId, "cooldown", String.valueOf(data.getCooldown()));
            rows.add(row);
        }
        return rows;
    }

    private List<KeyValueRow> getUnclaimedItemsRow(List<KeyIntPair> unclaimedItems) {
        ArrayList<KeyValueRow> rows = new ArrayList<KeyValueRow>();
        if (unclaimedItems.isEmpty()) {
            return rows;
        }
        for (KeyIntPair unclaimedItem : unclaimedItems) {
            KeyValueRow row = new KeyValueRow(4, null, unclaimedItem.getKey(), String.valueOf(unclaimedItem.getValue()));
            rows.add(row);
        }
        return rows;
    }

    private List<KeyValueRow> getActionBarRow(User user) {
        ArrayList<KeyValueRow> rows = new ArrayList<KeyValueRow>();
        boolean shouldSave = false;
        for (ActionBarType type : ActionBarType.values()) {
            if (user.isActionBarEnabled(type)) continue;
            shouldSave = true;
        }
        if (!shouldSave) {
            return rows;
        }
        ActionBarType type = ActionBarType.IDLE;
        String keyName = type.toString().toLowerCase(Locale.ROOT);
        String value = String.valueOf(user.isActionBarEnabled(type));
        KeyValueRow row = new KeyValueRow(5, null, keyName, value);
        rows.add(row);
        return rows;
    }

    private List<KeyValueRow> getJobsRow(User user, Set<Skill> jobs) {
        ArrayList<KeyValueRow> rows = new ArrayList<KeyValueRow>();
        if (jobs.isEmpty()) {
            return rows;
        }
        String jobCommaList = String.join((CharSequence)",", jobs.stream().map(s -> s.getId().toString()).toList());
        KeyValueRow jobsRow = new KeyValueRow(6, null, "jobs", jobCommaList);
        rows.add(jobsRow);
        KeyValueRow timeRow = new KeyValueRow(6, null, JOBS_LAST_SELECT_TIME, String.valueOf(user.getLastJobSelectTime()));
        rows.add(timeRow);
        return rows;
    }

    private void saveAntiAfkLogs(List<AntiAfkLog> logs, Connection connection, User user) throws SQLException {
        String query = "INSERT IGNORE INTO auraskills_logs (log_type, log_time, log_level, log_message, player_uuid, player_coords, world_name) VALUES (?, ?, ?, ?, ?, ?, ?)";
        try (PreparedStatement ps = connection.prepareStatement("INSERT IGNORE INTO auraskills_logs (log_type, log_time, log_level, log_message, player_uuid, player_coords, world_name) VALUES (?, ?, ?, ?, ?, ?, ?)");){
            for (AntiAfkLog log : logs) {
                ps.setString(1, LOG_TYPE_ANTI_AFK);
                ps.setTimestamp(2, new Timestamp(log.timestamp()));
                ps.setInt(3, 2);
                ps.setString(4, log.message());
                ps.setString(5, user.getUuid().toString());
                ps.setString(6, log.coords().toString());
                ps.setString(7, log.world());
                ps.addBatch();
            }
            ps.executeBatch();
        }
    }

    @Override
    public void delete(UUID uuid) throws Exception {
        try (Connection connection = this.pool.getConnection();){
            int userId = this.getUserId(connection, uuid);
            this.deleteSkillLevelsUsers(connection, userId);
        }
    }

    @Override
    public List<UserState> loadStates(boolean ignoreOnline, boolean skipModifiers, long previousFetchTime) throws Exception {
        boolean enableLastUpdatedFilter = previousFetchTime > 0L && this.plugin.configBoolean(Option.SQL_OPTIMIZE_LEADERBOARD_UPDATING);
        String query = this.getLoadStatesQuery(enableLastUpdatedFilter);
        ArrayList<UserState> states = new ArrayList<UserState>();
        Map<String, Skill> skillCache = this.plugin.getSkillRegistry().getValues().stream().collect(Collectors.toMap(s -> s.getId().toString(), s -> s));
        try (Connection connection = this.pool.getConnection();
             PreparedStatement statement = connection.prepareStatement(query);){
            if (enableLastUpdatedFilter) {
                statement.setTimestamp(1, new Timestamp(previousFetchTime));
            }
            try (ResultSet rs = statement.executeQuery();){
                int currentId = -1;
                UUID uuid = null;
                double mana = 0.0;
                ConcurrentHashMap<Skill, Integer> lvl = new ConcurrentHashMap<Skill, Integer>();
                ConcurrentHashMap<Skill, Double> xp = new ConcurrentHashMap<Skill, Double>();
                while (rs.next()) {
                    Skill skill;
                    int userId = rs.getInt(1);
                    if (userId != currentId) {
                        this.checkAddUserState(ignoreOnline, skipModifiers, states, connection, currentId, uuid, mana, lvl, xp);
                        currentId = userId;
                        uuid = UUID.fromString(rs.getString(2));
                        mana = rs.getDouble(3);
                        lvl = new ConcurrentHashMap();
                        xp = new ConcurrentHashMap();
                    }
                    if ((skill = skillCache.get(rs.getString(4))) == null) continue;
                    lvl.put(skill, rs.getInt(5));
                    xp.put(skill, rs.getDouble(6));
                }
                this.checkAddUserState(ignoreOnline, skipModifiers, states, connection, currentId, uuid, mana, lvl, xp);
            }
        }
        return states;
    }

    @NotNull
    @Language(value="SQL")
    private String getLoadStatesQuery(boolean enableLastUpdatedFilter) {
        String query = enableLastUpdatedFilter ? "SELECT u.user_id, player_uuid, mana, skill_name, skill_level, skill_xp\nFROM auraskills_users u\nLEFT JOIN auraskills_skill_levels s USING (user_id)\nWHERE last_updated > ?\nORDER BY u.user_id\n" : "SELECT u.user_id, player_uuid, mana, skill_name, skill_level, skill_xp\nFROM auraskills_users u\nLEFT JOIN auraskills_skill_levels s USING (user_id)\nORDER BY u.user_id\n";
        return query;
    }

    private void checkAddUserState(boolean ignoreOnline, boolean skipModifiers, List<UserState> states, Connection connection, int currentId, UUID uuid, double mana, Map<Skill, Integer> lvl, Map<Skill, Double> xp) throws SQLException {
        if (currentId != -1) {
            boolean online = this.userManager.hasUser(uuid);
            if (!ignoreOnline || !online) {
                Map<String, TraitModifier> traitMods;
                Map<String, StatModifier> statMods;
                if (!skipModifiers) {
                    statMods = this.loadStatModifiers(connection, uuid, currentId);
                    traitMods = this.loadTraitModifiers(connection, uuid, currentId);
                } else {
                    statMods = Collections.emptyMap();
                    traitMods = Collections.emptyMap();
                }
                states.add(new UserState(uuid, lvl, xp, statMods, traitMods, mana));
            }
        }
    }

    @Override
    public List<AntiAfkLog> loadAntiAfkLogs(UUID uuid) {
        ArrayList<AntiAfkLog> arrayList;
        block24: {
            Connection connection = this.pool.getConnection();
            try {
                String query = "SELECT log_time, log_message, player_coords, world_name FROM auraskills_logs WHERE player_uuid=? AND log_type=?";
                ArrayList<AntiAfkLog> logs = new ArrayList<AntiAfkLog>();
                try (PreparedStatement statement = connection.prepareStatement(query);){
                    statement.setString(1, uuid.toString());
                    statement.setString(2, LOG_TYPE_ANTI_AFK);
                    try (ResultSet resultSet = statement.executeQuery();){
                        while (resultSet.next()) {
                            String coordsStr;
                            long timestamp = resultSet.getTimestamp("log_time").getTime();
                            String message = resultSet.getString("log_message");
                            if (message == null) {
                                message = "";
                            }
                            if ((coordsStr = resultSet.getString("player_coords")) == null) {
                                coordsStr = "";
                            }
                            BlockPosition coords = BlockPosition.fromCommaString(coordsStr);
                            String worldName = resultSet.getString("world_name");
                            logs.add(new AntiAfkLog(timestamp, message, coords, worldName));
                        }
                    }
                }
                arrayList = logs;
                if (connection == null) break block24;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.plugin.logger().warn("Failed to load anti-AFK logs from storage for UUID " + String.valueOf(uuid));
                    e.printStackTrace();
                    return new ArrayList<AntiAfkLog>();
                }
            }
            connection.close();
        }
        return arrayList;
    }
}

