/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.stat;

import dev.aurelium.auraskills.api.stat.CustomStat;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.stat.StatProvider;
import dev.aurelium.auraskills.api.stat.Stats;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.registry.Registry;
import dev.aurelium.auraskills.configurate.CommentedConfigurationNode;
import dev.aurelium.auraskills.configurate.ConfigurationNode;
import dev.aurelium.auraskills.configurate.serialize.SerializationException;

public class StatRegistry
extends Registry<Stat, StatProvider> {
    public StatRegistry(AuraSkillsPlugin plugin) {
        super(plugin, Stat.class, StatProvider.class);
        this.registerDefaults();
    }

    @Override
    public void registerDefaults() {
        for (Stats stat : Stats.values()) {
            this.register(stat.getId(), stat, this.plugin.getStatManager().getSupplier());
        }
    }

    public ConfigurationNode getDefinedConfig() throws SerializationException {
        CommentedConfigurationNode root = CommentedConfigurationNode.root();
        for (Stat stat : this.getValues()) {
            if (!(stat instanceof CustomStat)) continue;
            CustomStat customStat = (CustomStat)stat;
            ConfigurationNode statNode = root.node("stats", stat.getId().toString());
            statNode.node("enabled").set(true);
            for (Trait trait : customStat.getDefined().getTraits().keySet()) {
                double modifier = customStat.getDefined().getTraits().getOrDefault(trait, 1.0);
                statNode.node("traits", trait.getId().toString(), "modifier").set(modifier);
            }
        }
        return root;
    }
}

