/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.source.type;

import dev.aurelium.auraskills.api.source.SourceValues;
import dev.aurelium.auraskills.api.source.type.DamageXpSource;
import dev.aurelium.auraskills.api.source.type.EntityXpSource;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.source.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntitySource
extends Source
implements EntityXpSource {
    private final String entity;
    private final EntityXpSource.EntityTriggers[] triggers;
    private final EntityXpSource.EntityDamagers[] damagers;
    private final DamageXpSource.DamageCause[] causes;
    private final DamageXpSource.DamageCause[] excludedCauses;
    private final boolean scaleXpWithHealth;

    public EntitySource(AuraSkillsPlugin plugin, SourceValues values, String entity, EntityXpSource.EntityTriggers[] triggers, EntityXpSource.EntityDamagers[] damagers, @Nullable DamageXpSource.DamageCause[] causes, @Nullable DamageXpSource.DamageCause[] excludedCauses, boolean scaleXpWithHealth) {
        super(plugin, values);
        this.entity = entity;
        this.triggers = triggers;
        this.damagers = damagers;
        this.causes = causes;
        this.excludedCauses = excludedCauses;
        this.scaleXpWithHealth = scaleXpWithHealth;
    }

    @Override
    @NotNull
    public String getEntity() {
        return this.entity;
    }

    @Override
    @NotNull
    public EntityXpSource.EntityTriggers[] getTriggers() {
        return this.triggers;
    }

    @Override
    public EntityXpSource.EntityDamagers[] getDamagers() {
        return this.damagers;
    }

    @Override
    public boolean isVersionValid() {
        return this.plugin.getPlatformUtil().isValidEntityType(this.entity);
    }

    @Override
    public boolean scaleXpWithHealth() {
        return this.scaleXpWithHealth;
    }

    @Override
    @Nullable
    public DamageXpSource.DamageCause[] getCauses() {
        return this.causes;
    }

    @Override
    @Nullable
    public DamageXpSource.DamageCause[] getExcludedCauses() {
        return this.excludedCauses;
    }
}

