/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.source.type;

import com.google.common.collect.ImmutableMap;
import dev.aurelium.auraskills.api.source.SourceValues;
import dev.aurelium.auraskills.api.source.type.BlockXpSource;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.source.Source;
import dev.aurelium.auraskills.evalex.EvaluationException;
import dev.aurelium.auraskills.evalex.Expression;
import dev.aurelium.auraskills.evalex.parser.ParseException;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class BlockSource
extends Source
implements BlockXpSource {
    public static final int DEFAULT_MAX_BLOCKS = 100;
    private final String[] blocks;
    private final int maxBlocks;
    private final BlockXpSource.BlockTriggers[] triggers;
    private final boolean checkReplace;
    private final BlockXpSource.BlockXpSourceState[] states;
    private final BlockXpSource.BlockXpSourceState[] afterStates;
    private final String stateMultiplier;
    private final BlockXpSource.SupportBlockType supportBlockType;
    private final boolean allowBoneMeal;

    public BlockSource(AuraSkillsPlugin plugin, SourceValues values, String[] blocks, int maxBlocks, BlockXpSource.BlockTriggers[] triggers, boolean checkReplace, BlockXpSource.BlockXpSourceState[] states, BlockXpSource.BlockXpSourceState[] afterStates, String stateMultiplier, BlockXpSource.SupportBlockType supportBlockType, boolean allowBoneMeal) {
        super(plugin, values);
        this.blocks = blocks;
        this.maxBlocks = maxBlocks;
        this.triggers = triggers;
        this.checkReplace = checkReplace;
        this.states = states;
        this.afterStates = afterStates;
        this.stateMultiplier = stateMultiplier;
        this.supportBlockType = supportBlockType;
        this.allowBoneMeal = allowBoneMeal;
    }

    @Override
    public String getBlock() {
        return this.blocks[0];
    }

    @Override
    public String[] getBlocks() {
        return this.blocks;
    }

    @Override
    public int getMaxBlocks() {
        return this.maxBlocks;
    }

    @Override
    public BlockXpSource.BlockTriggers[] getTriggers() {
        return this.triggers;
    }

    @Override
    public boolean checkReplace() {
        return this.checkReplace;
    }

    @Override
    @Nullable
    public BlockXpSource.BlockXpSourceState[] getStates() {
        return this.states;
    }

    @Override
    @Nullable
    public BlockXpSource.BlockXpSourceState[] getAfterStates() {
        return this.afterStates;
    }

    @Override
    public double getStateMultiplier(String stateKey, Object stateValue) {
        String replaced = this.stateMultiplier.replace(stateKey, stateValue.toString());
        Expression expression = new Expression(replaced);
        try {
            return expression.evaluate().getNumberValue().doubleValue();
        }
        catch (EvaluationException | ParseException e) {
            e.printStackTrace();
            return 1.0;
        }
    }

    @Override
    public boolean hasStateMultiplier() {
        return !this.stateMultiplier.isEmpty();
    }

    public String getStateMultiplier() {
        return this.stateMultiplier;
    }

    @Override
    public boolean requiresSupportBlock(BlockXpSource.SupportBlockType direction) {
        return this.supportBlockType == direction;
    }

    public BlockXpSource.SupportBlockType getSupportBlockType() {
        return this.supportBlockType;
    }

    @Override
    public boolean allowBoneMeal() {
        return this.allowBoneMeal;
    }

    @Override
    public boolean isVersionValid() {
        for (String blockStr : this.blocks) {
            if (this.plugin.getPlatformUtil().isValidMaterial(blockStr)) continue;
            return false;
        }
        return true;
    }

    public static class BlockSourceState
    implements BlockXpSource.BlockXpSourceState {
        private final Map<String, Object> stateMap;

        public BlockSourceState(ImmutableMap<String, Object> stateMap) {
            this.stateMap = stateMap;
        }

        @Override
        public Map<String, Object> getStateMap() {
            return this.stateMap;
        }

        @Override
        public int getInt(String key) {
            return (Integer)this.stateMap.getOrDefault(key, 0);
        }

        @Override
        public double getDouble(String key) {
            return (Double)this.stateMap.getOrDefault(key, 0.0);
        }

        @Override
        public String getString(String key) {
            return (String)this.stateMap.getOrDefault(key, "");
        }

        @Override
        public boolean getBoolean(String key) {
            return (Boolean)this.stateMap.getOrDefault(key, false);
        }

        @Override
        public boolean containsKey(String key, Class<?> type) {
            Object obj = this.stateMap.get(key);
            if (obj == null) {
                return false;
            }
            return type.isInstance(obj);
        }
    }
}

