/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.source.parser.util;

import dev.aurelium.auraskills.api.config.ConfigNode;
import dev.aurelium.auraskills.api.item.ItemFilterMeta;
import dev.aurelium.auraskills.api.item.PotionData;
import dev.aurelium.auraskills.api.source.BaseContext;
import dev.aurelium.auraskills.api.source.UtilityParser;
import dev.aurelium.auraskills.common.item.SourceItemMeta;
import dev.aurelium.auraskills.common.source.parser.util.PotionDataParser;
import java.util.List;

public class ItemFilterMetaParser
implements UtilityParser<ItemFilterMeta> {
    @Override
    public ItemFilterMeta parse(ConfigNode source, BaseContext context) {
        String displayName = source.node("display_name").getString();
        List<String> lore = source.node("lore").getList(String.class);
        PotionData potionData = !source.node("potion_data").virtual() ? new PotionDataParser().parse(source.node("potion_data"), context) : null;
        boolean hasCustomModelData = source.node("has_custom_model_data").getBoolean(false);
        if (!source.node("custom_model_data").virtual()) {
            hasCustomModelData = true;
        }
        int customModelData = source.node("custom_model_data").getInt(Integer.MIN_VALUE);
        boolean ignoreCustomModelData = source.node("ignore_custom_model_data").getBoolean(false);
        return new SourceItemMeta(displayName, lore, potionData, hasCustomModelData, customModelData, ignoreCustomModelData);
    }
}

