/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.source;

import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.source.SourceIncome;
import dev.aurelium.auraskills.api.source.SourceType;
import dev.aurelium.auraskills.api.source.SourceValues;
import dev.aurelium.auraskills.api.source.XpSource;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.message.MessageKey;
import dev.aurelium.auraskills.common.source.SourceTypes;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class Source
implements XpSource {
    protected final AuraSkillsPlugin plugin;
    private final SourceValues values;

    public Source(AuraSkillsPlugin plugin, SourceValues values) {
        this.plugin = plugin;
        this.values = values;
    }

    @Override
    public NamespacedId getId() {
        return this.values.getId();
    }

    @Override
    public SourceType getType() {
        return this.values.getType();
    }

    @Override
    public String getDisplayName(Locale locale) {
        SourceType sourceType = this.getType();
        if (sourceType == null) {
            return this.getId().getKey();
        }
        String messagePath = "sources." + sourceType.toString().toLowerCase(Locale.ROOT) + "." + this.getId().getKey().toLowerCase(Locale.ROOT);
        String msg = this.plugin.getMsg(MessageKey.of(messagePath), locale);
        if (msg.equals(messagePath)) {
            if (this.values.getDisplayName() != null) {
                return this.values.getDisplayName();
            }
            if (sourceType == SourceTypes.BLOCK) {
                return "!!REMOVE!!";
            }
            if (sourceType == SourceTypes.ENTITY) {
                return "<lang:entity.minecraft." + this.getId().getKey() + ">";
            }
        }
        return msg;
    }

    @Override
    @Nullable
    public String getUnitName(Locale locale) {
        return this.plugin.getApi().getSourceManager().getUnitName(this, locale);
    }

    @Override
    public String name() {
        return this.getId().getKey().toUpperCase(Locale.ROOT);
    }

    @Override
    public double getXp() {
        return this.values.getXp();
    }

    @Override
    public SourceIncome getIncome() {
        return this.values.getIncome();
    }

    @Override
    public SourceValues getValues() {
        return this.values;
    }

    public String toString() {
        return this.getId().toString();
    }
}

