/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.skill;

import com.google.common.collect.ImmutableList;
import dev.aurelium.auraskills.api.ability.Ability;
import dev.aurelium.auraskills.api.mana.ManaAbility;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.registry.NamespacedRegistry;
import dev.aurelium.auraskills.api.skill.CustomSkill;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.skill.Skills;
import dev.aurelium.auraskills.api.source.XpSource;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.ability.AbilityLoader;
import dev.aurelium.auraskills.common.ability.LoadedAbility;
import dev.aurelium.auraskills.common.config.ConfigurateLoader;
import dev.aurelium.auraskills.common.mana.LoadedManaAbility;
import dev.aurelium.auraskills.common.mana.ManaAbilityLoader;
import dev.aurelium.auraskills.common.skill.LoadedSkill;
import dev.aurelium.auraskills.common.skill.SkillOptions;
import dev.aurelium.auraskills.common.source.SourceLoader;
import dev.aurelium.auraskills.common.source.SourceTag;
import dev.aurelium.auraskills.configurate.ConfigurationNode;
import dev.aurelium.auraskills.configurate.serialize.SerializationException;
import dev.aurelium.auraskills.configurate.serialize.TypeSerializerCollection;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SkillLoader {
    private static final String FILE_NAME = "skills.yml";
    private final AuraSkillsPlugin plugin;
    private final SourceLoader sourceLoader;
    private final ConfigurateLoader configurateLoader;
    private final AbilityLoader abilityLoader;
    private final ManaAbilityLoader manaAbilityLoader;

    public SkillLoader(AuraSkillsPlugin plugin) {
        this.plugin = plugin;
        this.sourceLoader = new SourceLoader(plugin);
        TypeSerializerCollection skillSerializers = TypeSerializerCollection.builder().build();
        this.configurateLoader = new ConfigurateLoader(plugin, skillSerializers);
        this.abilityLoader = new AbilityLoader(plugin);
        this.manaAbilityLoader = new ManaAbilityLoader(plugin);
    }

    public void loadSkills() {
        try {
            this.plugin.getSkillManager().unregisterAll();
            this.plugin.getSkillManager().clearCache();
            this.plugin.getAbilityManager().unregisterAll();
            this.plugin.getManaAbilityManager().unregisterAll();
            this.configurateLoader.updateUserFile(FILE_NAME);
            ConfigurationNode main = this.configurateLoader.loadUserFile(FILE_NAME);
            ConfigurationNode defined = this.plugin.getSkillRegistry().getDefinedConfig();
            ConfigurationNode root = this.configurateLoader.loadContentAndMerge(defined, FILE_NAME, main);
            ConfigurationNode skillsNode = root.node("skills");
            this.abilityLoader.init();
            this.manaAbilityLoader.init();
            int skillsLoaded = 0;
            int sourcesLoaded = 0;
            for (Object key : skillsNode.childrenMap().keySet()) {
                String skillName = (String)key;
                Skill skill = (Skill)this.plugin.getSkillRegistry().get(NamespacedId.fromString(skillName));
                ConfigurationNode skillNode = skillsNode.node(skillName);
                LoadedSkill loadedSkill = this.loadSkill(skill, skillNode);
                this.plugin.getSkillManager().register(skill, loadedSkill);
                ++skillsLoaded;
                sourcesLoaded += loadedSkill.sources().size();
            }
            this.plugin.logger().info("Loaded " + skillsLoaded + " skills with " + sourcesLoaded + " total sources");
            for (Skill skill : this.plugin.getSkillManager().getSkillValues()) {
                this.loadSourceTags(skill);
            }
        }
        catch (IOException e) {
            this.plugin.logger().severe("Error loading skills.yml file: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public LoadedSkill loadSkill(Skill skill, ConfigurationNode config) throws SerializationException {
        ImmutableList<Ability> abilities = this.loadAbilities(skill, config);
        ManaAbility manaAbility = this.loadManaAbility(skill, config);
        SkillOptions options = this.loadSkillOptions(config.node("options"));
        return new LoadedSkill(skill, abilities, manaAbility, this.loadSources(skill), options);
    }

    private ImmutableList<Ability> loadAbilities(Skill skill, ConfigurationNode config) throws SerializationException {
        List<String> abilitiesStr = config.node("abilities").getList(String.class, new ArrayList());
        return (ImmutableList)abilitiesStr.stream().filter(s -> !s.isEmpty()).map(NamespacedId::fromDefault).map(id -> {
            try {
                Ability ability = (Ability)this.plugin.getAbilityRegistry().get((NamespacedId)id);
                this.createLoadedAbility(ability, skill);
                return ability;
            }
            catch (IllegalArgumentException e) {
                this.plugin.logger().warn("Could not find ability " + String.valueOf(id) + " while loading " + String.valueOf(skill.getId()));
                e.printStackTrace();
                return null;
            }
        }).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
    }

    private void createLoadedAbility(Ability ability, Skill skill) {
        try {
            LoadedAbility loadedAbility = this.abilityLoader.loadAbility(ability, skill);
            this.plugin.getAbilityManager().register(ability, loadedAbility);
        }
        catch (SerializationException e) {
            this.plugin.logger().severe("Error loading ability " + String.valueOf(ability.getId()) + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    private ManaAbility loadManaAbility(Skill skill, ConfigurationNode config) {
        String manaAbilityStr = config.node("mana_ability").getString();
        ManaAbility manaAbility = null;
        if (manaAbilityStr != null && !manaAbilityStr.isEmpty()) {
            try {
                manaAbility = (ManaAbility)this.plugin.getManaAbilityRegistry().get(NamespacedId.fromDefault(manaAbilityStr));
                this.createLoadedManaAbility(manaAbility, skill);
            }
            catch (IllegalArgumentException e) {
                this.plugin.logger().severe("Could not find mana ability " + manaAbilityStr + " while loading " + String.valueOf(skill.getId()));
            }
        }
        return manaAbility;
    }

    private void createLoadedManaAbility(ManaAbility manaAbility, Skill skill) {
        try {
            LoadedManaAbility loadedManaAbility = this.manaAbilityLoader.loadManaAbility(manaAbility, skill);
            this.plugin.getManaAbilityManager().register(manaAbility, loadedManaAbility);
        }
        catch (SerializationException e) {
            this.plugin.logger().severe("Error loading ability " + String.valueOf(manaAbility.getId()) + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    private ImmutableList<XpSource> loadSources(Skill skill) {
        if (skill instanceof Skills) {
            Skills auraSkill = (Skills)skill;
            return ImmutableList.copyOf(this.sourceLoader.loadSources(auraSkill, this.plugin.getPluginFolder(), true));
        }
        if (skill instanceof CustomSkill) {
            CustomSkill customSkill = (CustomSkill)skill;
            NamespacedRegistry registry = this.plugin.getApi().getNamespacedRegistry(customSkill.getId().getNamespace());
            if (registry != null) {
                return ImmutableList.copyOf(this.sourceLoader.loadSources(customSkill, registry.getContentDirectory(), false));
            }
        }
        return ImmutableList.of();
    }

    private SkillOptions loadSkillOptions(ConfigurationNode config) {
        HashMap<String, Object> optionMap = new HashMap<String, Object>();
        for (Object key : config.childrenMap().keySet()) {
            if (!(key instanceof String)) continue;
            ConfigurationNode node = config.node(key);
            optionMap.put((String)key, node.raw());
        }
        return new SkillOptions(optionMap);
    }

    private void loadSourceTags(Skill skill) {
        if (!skill.isEnabled()) {
            return;
        }
        NamespacedRegistry registry = this.plugin.getApi().getNamespacedRegistry(skill.getId().getNamespace());
        File contentDir = skill instanceof CustomSkill && registry != null ? registry.getContentDirectory() : this.plugin.getPluginFolder();
        Map<SourceTag, List<XpSource>> tagMap = this.sourceLoader.loadTags(skill, contentDir);
        for (Map.Entry<SourceTag, List<XpSource>> entry : tagMap.entrySet()) {
            this.plugin.getSkillManager().registerSourceTag(entry.getKey(), entry.getValue());
        }
    }
}

