/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.reward.parser;

import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.message.type.RewardMessage;
import dev.aurelium.auraskills.common.reward.SkillReward;
import dev.aurelium.auraskills.common.reward.builder.ItemRewardBuilder;
import dev.aurelium.auraskills.common.reward.parser.RewardParser;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import dev.aurelium.auraskills.configurate.ConfigurationNode;

public class ItemRewardParser
extends RewardParser {
    public ItemRewardParser(AuraSkillsPlugin plugin, Skill skill) {
        super(plugin, skill);
    }

    @Override
    public SkillReward parse(ConfigurationNode config) {
        RewardMessage messageKey;
        String effectiveName;
        String key = config.node("key").getString("");
        NamespacedId itemKey = NamespacedId.fromDefault(key);
        int amount = config.node("amount").empty() ? this.plugin.getItemRegistry().getItemAmount(itemKey) : config.node("amount").getInt(-1);
        ItemRewardBuilder builder = new ItemRewardBuilder(this.plugin).itemKey(itemKey).amount(amount);
        if (!config.node("menu_message").empty()) {
            builder.menuMessage(config.node("menu_message").getString());
        } else {
            effectiveName = this.plugin.getItemRegistry().getEffectiveItemName(itemKey);
            if (effectiveName != null) {
                messageKey = amount == 1 ? RewardMessage.ITEM_DEFAULT_MENU_MESSAGE : RewardMessage.ITEM_DEFAULT_MENU_MESSAGE_MULTIPLE;
                builder.menuMessage(TextUtil.replace(this.plugin.getMsg(messageKey, this.plugin.getDefaultLanguage()), "{display_name}", effectiveName, "{amount}", String.valueOf(amount), "{key}", key));
            }
        }
        if (!config.node("chat_message").empty()) {
            builder.chatMessage(config.node("chat_message").getString());
        } else {
            effectiveName = this.plugin.getItemRegistry().getEffectiveItemName(itemKey);
            if (effectiveName != null) {
                messageKey = amount == 1 ? RewardMessage.ITEM_DEFAULT_CHAT_MESSAGE : RewardMessage.ITEM_DEFAULT_CHAT_MESSAGE_MULTIPLE;
                builder.chatMessage(TextUtil.replace(this.plugin.getMsg(messageKey, this.plugin.getDefaultLanguage()), "{display_name}", effectiveName, "{amount}", String.valueOf(amount), "{key}", key));
            }
        }
        if (!config.node("message").empty()) {
            String message = config.node("message").getString();
            builder.chatMessage(message).menuMessage(message);
        }
        return builder.skill(this.skill).build();
    }
}

