/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.loot;

import dev.aurelium.auraskills.api.config.ConfigNode;
import dev.aurelium.auraskills.api.loot.LootContext;
import dev.aurelium.auraskills.api.loot.LootParsingContext;
import dev.aurelium.auraskills.api.loot.LootRequirements;
import dev.aurelium.auraskills.api.loot.LootValues;
import dev.aurelium.auraskills.common.api.implementation.ApiConfigNode;
import dev.aurelium.auraskills.common.loot.ContextProvider;
import dev.aurelium.auraskills.common.loot.LootManager;
import dev.aurelium.auraskills.configurate.ConfigurationNode;
import dev.aurelium.auraskills.configurate.serialize.SerializationException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class LootParsingContextImpl
implements LootParsingContext {
    private final LootManager manager;

    public LootParsingContextImpl(LootManager manager) {
        this.manager = manager;
    }

    @Override
    public LootValues parseValues(ConfigNode apiConfig, LootRequirements requirements) {
        ConfigurationNode config = ((ApiConfigNode)apiConfig).getBacking();
        int weight = config.node("weight").getInt(10);
        String message = config.node("message").getString("");
        return new LootValues(weight, message, this.parseContexts(config), this.parseOptions(config), requirements);
    }

    public Map<String, Set<LootContext>> parseContexts(ConfigurationNode config) {
        ConcurrentHashMap<String, Set<LootContext>> contexts = new ConcurrentHashMap<String, Set<LootContext>>();
        for (String contextKey : this.manager.getContextKeySet()) {
            Set<LootContext> lootContext;
            ContextProvider contextProvider;
            if (config.node(contextKey).virtual() || (contextProvider = this.manager.getContextProvider(contextKey)) == null) continue;
            try {
                lootContext = contextProvider.parseContext(config);
            }
            catch (SerializationException e) {
                throw new RuntimeException(e);
            }
            if (lootContext == null) continue;
            contexts.put(contextKey, lootContext);
        }
        return contexts;
    }

    public Map<String, Object> parseOptions(ConfigurationNode config) {
        ConcurrentHashMap<String, Object> options = new ConcurrentHashMap<String, Object>();
        for (String optionKey : this.manager.getLootOptionKeys()) {
            if (config.node(optionKey).virtual()) continue;
            Object option = config.node(optionKey).raw();
            options.put(optionKey, option);
        }
        return options;
    }
}

