/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.loot;

import com.google.common.collect.Sets;
import dev.aurelium.auraskills.api.loot.LootParser;
import dev.aurelium.auraskills.api.loot.LootRequirements;
import dev.aurelium.auraskills.api.loot.LootTable;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.loot.ContextProvider;
import dev.aurelium.auraskills.common.loot.SourceContextProvider;
import dev.aurelium.auraskills.configurate.ConfigurationNode;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public abstract class LootManager {
    private final AuraSkillsPlugin plugin;
    private final Map<NamespacedId, LootTable> lootTables = new ConcurrentHashMap<NamespacedId, LootTable>();
    private final Map<String, ContextProvider> contextProviders;
    private final Set<String> lootOptionKeys;
    private final Set<String> poolOptionKeys;
    private final Map<String, LootParser> customLootParsers;

    public LootManager(AuraSkillsPlugin plugin) {
        this.plugin = plugin;
        this.contextProviders = new ConcurrentHashMap<String, ContextProvider>();
        this.lootOptionKeys = Sets.newConcurrentHashSet();
        this.poolOptionKeys = Sets.newConcurrentHashSet();
        this.customLootParsers = new ConcurrentHashMap<String, LootParser>();
        this.registerContextProvider(new SourceContextProvider(plugin));
        this.addLootOptionKeys("xp");
        this.addPoolOptionKeys("chance_per_luck", "require_open_water");
    }

    public abstract LootRequirements getLootRequirements(ConfigurationNode var1);

    public AuraSkillsPlugin getPlugin() {
        return this.plugin;
    }

    @Nullable
    public LootTable getLootTable(Skill skill) {
        return this.lootTables.get(skill.getId());
    }

    @Nullable
    public LootTable getLootTable(NamespacedId id) {
        return this.lootTables.get(id);
    }

    public Map<NamespacedId, LootTable> getLootTables() {
        return this.lootTables;
    }

    public void addLootTable(NamespacedId id, LootTable lootTable) {
        this.lootTables.put(id, lootTable);
    }

    public Set<String> getContextKeySet() {
        return this.contextProviders.keySet();
    }

    @Nullable
    public ContextProvider getContextProvider(String contextKey) {
        return this.contextProviders.get(contextKey);
    }

    public void registerContextProvider(ContextProvider contextProvider) {
        this.contextProviders.put(contextProvider.getContextKey(), contextProvider);
    }

    public Set<String> getLootOptionKeys() {
        return this.lootOptionKeys;
    }

    public void addLootOptionKeys(String ... keys) {
        this.lootOptionKeys.addAll(Arrays.asList(keys));
    }

    public Set<String> getPoolOptionKeys() {
        return this.poolOptionKeys;
    }

    public void addPoolOptionKeys(String ... keys) {
        this.poolOptionKeys.addAll(Arrays.asList(keys));
    }

    public Map<String, LootParser> getCustomLootParsers() {
        return this.customLootParsers;
    }

    public void registerCustomLootParser(String name, LootParser parser) {
        this.customLootParsers.put(name, parser);
    }
}

