/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.loot;

import dev.aurelium.auraskills.api.ability.Ability;
import dev.aurelium.auraskills.api.loot.Loot;
import dev.aurelium.auraskills.api.loot.LootContext;
import dev.aurelium.auraskills.api.loot.LootPool;
import dev.aurelium.auraskills.api.source.XpSource;
import dev.aurelium.auraskills.api.stat.Stats;
import dev.aurelium.auraskills.common.loot.SourceContext;
import dev.aurelium.auraskills.common.user.User;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;

public abstract class AbstractLootHandler {
    public double getCommonChance(LootPool pool, User user) {
        double chancePerLuck = pool.getOption("chance_per_luck", Double.class, 0.0) / 100.0;
        return pool.getBaseChance() + chancePerLuck * user.getStatLevel(Stats.LUCK);
    }

    public double getAbilityModifiedChance(double chance, Ability ability, User user) {
        chance = ability.optionBoolean("scale_base_chance", false) ? (chance *= 1.0 + ability.getValue(user.getAbilityLevel(ability)) / 100.0) : (chance += ability.getValue(user.getAbilityLevel(ability)) / 100.0);
        return chance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isPoolUnobtainable(LootPool pool, XpSource source) {
        Iterator<Loot> iterator = pool.getLoot().iterator();
        block2: while (true) {
            if (!iterator.hasNext()) {
                return true;
            }
            Loot loot = iterator.next();
            Set contexts = loot.getValues().getContexts().getOrDefault("sources", new HashSet());
            if (contexts.isEmpty()) {
                return false;
            }
            Iterator iterator2 = contexts.iterator();
            while (true) {
                if (!iterator2.hasNext()) continue block2;
                LootContext context = (LootContext)iterator2.next();
                if (!(context instanceof SourceContext)) continue;
                SourceContext sourceContext = (SourceContext)context;
                try {
                    // empty try
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                XpSource xpSource = sourceContext.source();
                XpSource contextSource = xpSource;
                if (contextSource.equals(source)) break block2;
            }
            break;
        }
        return false;
    }

    protected int generateAmount(int minAmount, int maxAmount) {
        return ThreadLocalRandom.current().nextInt(maxAmount - minAmount + 1) + minAmount;
    }
}

