/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.config.preset;

import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.config.ConfigurateLoader;
import dev.aurelium.auraskills.common.config.preset.ConfigPreset;
import dev.aurelium.auraskills.common.config.preset.PresetAction;
import dev.aurelium.auraskills.common.config.preset.PresetEntry;
import dev.aurelium.auraskills.common.config.preset.PresetLoadException;
import dev.aurelium.auraskills.common.config.preset.PresetLoadResult;
import dev.aurelium.auraskills.common.util.file.FileUtil;
import dev.aurelium.auraskills.configurate.ConfigurateException;
import dev.aurelium.auraskills.configurate.ConfigurationNode;
import dev.aurelium.auraskills.configurate.serialize.TypeSerializerCollection;
import dev.aurelium.auraskills.configurate.yaml.NodeStyle;
import dev.aurelium.auraskills.configurate.yaml.YamlConfigurationLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class PresetManager {
    private final AuraSkillsPlugin plugin;

    public PresetManager(AuraSkillsPlugin plugin) {
        this.plugin = plugin;
    }

    public ConfigPreset preparePreset(String name) throws PresetLoadException {
        if (!name.endsWith(".zip")) {
            throw new PresetLoadException("File name must end in .zip");
        }
        File zipFile = new File(this.plugin.getPluginFolder(), "presets/" + name);
        if (!zipFile.exists()) {
            throw new PresetLoadException("Preset file does not exist in the presets folder");
        }
        try {
            ConfigurationNode presetConfig = this.getPresetConfig(zipFile);
            List<PresetEntry> entries = this.parsePresetEntries(presetConfig);
            return new ConfigPreset(name, zipFile, entries);
        }
        catch (IOException e) {
            throw new PresetLoadException(e.getMessage());
        }
    }

    public PresetLoadResult loadPreset(ConfigPreset preset) throws IOException {
        ArrayList<String> created = new ArrayList<String>();
        ArrayList<String> modified = new ArrayList<String>();
        ArrayList<String> replaced = new ArrayList<String>();
        ArrayList<String> deleted = new ArrayList<String>();
        ArrayList<String> skipped = new ArrayList<String>();
        try (ZipFile zipFile = new ZipFile(preset.zipFile(), 1);){
            for (PresetEntry presetEntry : preset.entries()) {
                int result = this.loadPresetEntry(presetEntry, zipFile);
                switch (result) {
                    case 0: {
                        created.add(presetEntry.name());
                        break;
                    }
                    case 1: {
                        modified.add(presetEntry.name());
                        break;
                    }
                    case 2: {
                        replaced.add(presetEntry.name());
                        break;
                    }
                    case 3: {
                        skipped.add(presetEntry.name());
                    }
                }
            }
        }
        return new PresetLoadResult(created, modified, replaced, deleted, skipped);
    }

    private int loadPresetEntry(PresetEntry presetEntry, ZipFile zipFile) throws IOException {
        ConfigurationNode merged;
        String path = "files/" + presetEntry.name();
        ZipEntry zipEntry = zipFile.getEntry(path);
        if (zipEntry == null) {
            return 3;
        }
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        File existingFile = new File(this.plugin.getPluginFolder(), presetEntry.name());
        if (!existingFile.exists()) {
            Files.createDirectories(existingFile.toPath().getParent(), new FileAttribute[0]);
            Files.copy(inputStream, existingFile.toPath(), new CopyOption[0]);
            return 0;
        }
        if (presetEntry.action() == PresetAction.REPLACE) {
            Files.copy(inputStream, existingFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return 2;
        }
        ConfigurationNode presetConfig = this.loadInputStream(inputStream);
        ConfigurationNode existingConfig = FileUtil.loadYamlFile(existingFile);
        ConfigurateLoader loader = new ConfigurateLoader(this.plugin, TypeSerializerCollection.builder().build());
        if (presetEntry.action() == PresetAction.MERGE) {
            merged = loader.mergeNodes(existingConfig, presetConfig);
        } else if (presetEntry.action() == PresetAction.APPEND) {
            merged = loader.mergeNodes(presetConfig, existingConfig);
        } else {
            return 3;
        }
        FileUtil.saveYamlFile(existingFile, merged);
        return 1;
    }

    private ConfigurationNode getPresetConfig(File file) throws IOException {
        try (ZipFile zipFile = new ZipFile(file, 1);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                if (zipEntry.isDirectory() || !zipEntry.getName().equals("preset.yml")) continue;
                try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                    ConfigurationNode configurationNode = this.loadInputStream(inputStream);
                    return configurationNode;
                }
            }
            throw new PresetLoadException("No preset.yml configuration file was found in the zip");
        }
    }

    public List<PresetEntry> parsePresetEntries(ConfigurationNode root) {
        int fileVersion = root.node("file_version").getInt();
        if (fileVersion != 1) {
            throw new PresetLoadException("Preset has an incompatible file_version");
        }
        ArrayList<PresetEntry> entries = new ArrayList<PresetEntry>();
        for (ConfigurationNode configurationNode : root.node("files").childrenList()) {
            String path = configurationNode.node("path").getString();
            if (path == null) continue;
            PresetAction action = PresetAction.valueOf(configurationNode.node("action").getString("replace").toUpperCase(Locale.ROOT));
            entries.add(new PresetEntry(path, action));
        }
        return entries;
    }

    private ConfigurationNode loadInputStream(InputStream inputStream) throws ConfigurateException {
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().defaultOptions(opts -> opts.shouldCopyDefaults(false))).source(() -> new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)))).nodeStyle(NodeStyle.BLOCK).build();
        return loader.load();
    }
}

