/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.config;

import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.util.file.FileUtil;
import dev.aurelium.auraskills.configurate.ConfigurateException;
import dev.aurelium.auraskills.configurate.ConfigurationNode;
import dev.aurelium.auraskills.configurate.serialize.SerializationException;
import dev.aurelium.auraskills.configurate.serialize.TypeSerializerCollection;
import dev.aurelium.auraskills.configurate.yaml.YamlConfigurationLoader;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public class ConfigurateLoader {
    private final AuraSkillsPlugin plugin;
    private final ClassLoader classLoader;
    private final TypeSerializerCollection serializers;

    public ConfigurateLoader(AuraSkillsPlugin plugin, TypeSerializerCollection serializers) {
        this.plugin = plugin;
        this.classLoader = plugin.getClass().getClassLoader();
        this.serializers = serializers == null ? TypeSerializerCollection.builder().build() : serializers;
    }

    public ConfigurationNode loadEmbeddedFile(String fileName) throws IOException {
        ConfigurationNode config = this.loadEmbeddedFileOrNull(fileName);
        if (config == null) {
            throw new IllegalArgumentException("File " + fileName + "does not exist");
        }
        return config;
    }

    @Nullable
    public ConfigurationNode loadEmbeddedFileOrNull(String fileName) throws IOException {
        URI uri = FileUtil.getEmbeddedURI(fileName, this.classLoader);
        if (uri == null) {
            return null;
        }
        ConcurrentHashMap<String, String> env = new ConcurrentHashMap<String, String>();
        env.put("create", "true");
        if ("jar".equals(uri.getScheme())) {
            try (FileSystem ignored = FileSystems.newFileSystem(uri, env);){
                ConfigurationNode configurationNode = this.loadFromUri(uri);
                return configurationNode;
            }
        }
        return this.loadFromUri(uri);
    }

    private ConfigurationNode loadFromUri(URI uri) throws ConfigurateException {
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(Path.of(uri))).defaultOptions(opts -> opts.shouldCopyDefaults(false).serializers(build -> build.registerAll(this.serializers)))).build();
        return loader.load();
    }

    public ConfigurationNode loadUserFile(String path) throws IOException {
        File file = new File(this.plugin.getPluginFolder(), path);
        if (!file.exists()) {
            throw new RuntimeException("File does not exist!");
        }
        return this.loadUserFile(file);
    }

    public ConfigurationNode loadUserFile(File file) throws IOException {
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(file.toPath())).defaultOptions(opts -> opts.shouldCopyDefaults(false).serializers(build -> build.registerAll(this.serializers)))).build();
        return loader.load();
    }

    public void updateUserFile(String path) throws IOException {
        ConfigurationNode embedded = this.loadEmbeddedFile(path);
        File userFile = new File(this.plugin.getPluginFolder(), path);
        ConfigurationNode user = this.loadUserFile(userFile);
        int embeddedVer = embedded.node("file_version").getInt(-1);
        int userVer = user.node("file_version").getInt(0);
        if (embeddedVer == -1) {
            throw new IllegalStateException("Embedded file does not have a file_version");
        }
        if (embeddedVer > userVer) {
            ConfigurationNode merged = this.mergeNodes(embedded, user);
            merged.node("file_version").set(embeddedVer);
            this.saveConfigIfUpdated(userFile, embedded, user, merged);
        }
    }

    public void saveConfigIfUpdated(File file, ConfigurationNode embedded, ConfigurationNode user, ConfigurationNode merged) throws IOException {
        int missing = this.countMissing(embedded, user);
        if (missing > 0) {
            FileUtil.saveYamlFile(file, merged);
            String path = this.plugin.getPluginFolder().toPath().relativize(file.toPath()).toString();
            this.plugin.logger().info("Updated " + path + " with " + missing + " new key" + (missing != 1 ? "s" : ""));
        }
    }

    public int countMissing(ConfigurationNode embedded, ConfigurationNode user) {
        int count = 0;
        Stack<? extends ConfigurationNode> stack = new Stack<ConfigurationNode>();
        List<ConfigurationNode> nonExperimentalNodes = embedded.childrenMap().values().stream().filter(n -> !String.valueOf(n.key()).equals("experimental")).toList();
        stack.addAll(nonExperimentalNodes);
        while (!stack.isEmpty()) {
            ConfigurationNode node = (ConfigurationNode)stack.pop();
            if (node.isMap()) {
                stack.addAll(node.childrenMap().values());
                continue;
            }
            if (!user.node(node.path()).virtual()) continue;
            ++count;
        }
        return count;
    }

    public int countChildren(ConfigurationNode root) {
        int count = 0;
        Stack<ConfigurationNode> stack = new Stack<ConfigurationNode>();
        stack.addAll(root.childrenMap().values());
        while (!stack.isEmpty()) {
            ConfigurationNode node = (ConfigurationNode)stack.pop();
            if (node.isMap()) {
                stack.addAll(node.childrenMap().values());
                continue;
            }
            ++count;
        }
        return count;
    }

    public void generateUserFile(String path) {
        try {
            ConfigurationNode config = this.loadEmbeddedFileOrNull(path);
            if (config == null) {
                return;
            }
            File file = new File(this.plugin.getPluginFolder(), path);
            if (!file.exists()) {
                FileUtil.saveYamlFile(file, config);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ConfigurationNode mergeNodes(ConfigurationNode ... nodes) throws SerializationException {
        if (nodes.length == 0) {
            throw new IllegalArgumentException("Must provide at least one node");
        }
        ConfigurationNode merged = nodes[0].copy();
        for (int i = 1; i < nodes.length; ++i) {
            ConfigurationNode node = nodes[i];
            if (node == null) continue;
            this.mergeRec(merged, node);
        }
        return merged;
    }

    private void mergeRec(ConfigurationNode base, ConfigurationNode source) throws SerializationException {
        for (ConfigurationNode configurationNode : source.childrenMap().values()) {
            if (configurationNode.isMap()) {
                this.mergeRec(base.node(configurationNode.key()), configurationNode);
                continue;
            }
            base.node(configurationNode.key()).set(configurationNode.raw());
        }
    }

    public ConfigurationNode loadContentAndMerge(@Nullable ConfigurationNode base, String path, ConfigurationNode ... others) throws SerializationException {
        ArrayList<ConfigurationNode> loadedFiles = new ArrayList<ConfigurationNode>();
        if (base != null) {
            loadedFiles.add(base);
        }
        for (File dir : this.plugin.getSkillManager().getContentDirectories()) {
            File file = new File(dir, path);
            try {
                ConfigurationNode config = this.loadUserFile(file);
                loadedFiles.add(config);
            }
            catch (IOException e) {
                this.plugin.logger().warn("Failed to load file " + file.getName() + " in content directory " + dir.getPath());
                e.printStackTrace();
            }
        }
        loadedFiles.addAll(Arrays.asList(others));
        return this.mergeNodes(loadedFiles.toArray(new ConfigurationNode[0]));
    }
}

