/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.commands;

import dev.aurelium.auraskills.acf.BaseCommand;
import dev.aurelium.auraskills.acf.CommandIssuer;
import dev.aurelium.auraskills.acf.annotation.CommandAlias;
import dev.aurelium.auraskills.acf.annotation.CommandCompletion;
import dev.aurelium.auraskills.acf.annotation.CommandPermission;
import dev.aurelium.auraskills.acf.annotation.Default;
import dev.aurelium.auraskills.acf.annotation.Description;
import dev.aurelium.auraskills.acf.annotation.Flags;
import dev.aurelium.auraskills.acf.annotation.Optional;
import dev.aurelium.auraskills.acf.annotation.Subcommand;
import dev.aurelium.auraskills.api.trait.Traits;
import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.message.MessageBuilder;
import dev.aurelium.auraskills.common.message.MessageKey;
import dev.aurelium.auraskills.common.message.type.CommandMessage;
import dev.aurelium.auraskills.common.user.User;
import java.util.Locale;

@CommandAlias(value="mana")
public class ManaCommand
extends BaseCommand {
    private final AuraSkillsPlugin plugin;

    public ManaCommand(AuraSkillsPlugin plugin) {
        this.plugin = plugin;
    }

    @Default
    @CommandPermission(value="auraskills.command.mana")
    @Description(value="%desc_mana")
    public void onMana(CommandIssuer issuer, @Flags(value="other") @CommandPermission(value="auraskills.command.mana.other") @Optional User user) {
        if (issuer.isPlayer()) {
            User issuerUser = this.plugin.getUserManager().getUser(issuer.getUniqueId());
            if (issuerUser == null) {
                return;
            }
            Locale locale = issuerUser.getLocale();
            MessageBuilder.create(this.plugin).locale(locale).prefix().message((MessageKey)CommandMessage.MANA_DISPLAY, "current", NumberUtil.format1(issuerUser.getMana()), "max", NumberUtil.format1(issuerUser.getMaxMana())).send(issuer);
        } else if (user != null) {
            Locale locale = user.getLocale();
            MessageBuilder.create(this.plugin).locale(locale).prefix().message((MessageKey)CommandMessage.MANA_DISPLAY_OTHER, "player", user.getUsername(), "current", NumberUtil.format1(user.getMana()), "max", NumberUtil.format1(user.getMaxMana())).send(issuer);
        } else {
            Locale defLocale = this.plugin.getDefaultLanguage();
            MessageBuilder.create(this.plugin).locale(defLocale).prefix().message((MessageKey)CommandMessage.MANA_CONSOLE_SPECIFY_PLAYER, new String[0]).send(issuer);
        }
    }

    @Subcommand(value="add")
    @CommandPermission(value="auraskills.command.mana.add")
    @CommandCompletion(value="@players @nothing false|true")
    @Description(value="%desc_mana_add")
    public void onManaAdd(CommandIssuer issuer, @Flags(value="other") User user, double amount, @Default(value="true") boolean allowOverMax, @Default(value="false") boolean silent) {
        Locale locale = user.getLocale();
        if (amount < 0.0) {
            if (!silent) {
                issuer.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.MANA_AT_LEAST_ZERO, locale));
            }
            return;
        }
        double manaToAdd = amount;
        if (user.getMana() + manaToAdd > user.getMaxMana()) {
            boolean allowOverflow;
            boolean bl = allowOverflow = Traits.MAX_MANA.isEnabled() && Traits.MAX_MANA.optionBoolean("allow_overflow");
            if (!allowOverMax || !allowOverflow) {
                manaToAdd = user.getMaxMana() - user.getMana();
            }
        }
        if (manaToAdd > 0.0) {
            user.setMana(user.getMana() + manaToAdd);
        }
        if (!silent) {
            MessageBuilder.create(this.plugin).locale(locale).prefix().message((MessageKey)CommandMessage.MANA_ADD_ADDED, "amount", NumberUtil.format2(manaToAdd), "player", user.getUsername()).send(issuer);
        }
    }

    @Subcommand(value="remove")
    @CommandPermission(value="auraskills.command.mana.remove")
    @CommandCompletion(value="@players")
    @Description(value="%desc_mana_remove")
    public void onManaRemove(CommandIssuer issuer, @Flags(value="other") User user, double amount, @Default(value="false") boolean silent) {
        Locale locale = user.getLocale();
        if (amount < 0.0) {
            if (!silent) {
                MessageBuilder.create(this.plugin).locale(locale).prefix().message((MessageKey)CommandMessage.MANA_AT_LEAST_ZERO, new String[0]).send(issuer);
            }
            return;
        }
        double manaToRemove = amount;
        if (user.getMana() - manaToRemove < 0.0) {
            manaToRemove = user.getMana();
        }
        user.setMana(user.getMana() - manaToRemove);
        if (!silent) {
            MessageBuilder.create(this.plugin).locale(locale).prefix().message((MessageKey)CommandMessage.MANA_REMOVE_REMOVED, "amount", NumberUtil.format2(manaToRemove), "player", user.getUsername()).send(issuer);
        }
    }

    @Subcommand(value="set")
    @CommandPermission(value="auraskills.command.mana.set")
    @CommandCompletion(value="@players @nothing false|true")
    @Description(value="%desc_mana_set")
    public void onManaSet(CommandIssuer issuer, @Flags(value="other") User user, double amount, @Default(value="true") boolean allowOverMax, @Default(value="false") boolean silent) {
        double manaToSet;
        if (user == null) {
            return;
        }
        Locale locale = user.getLocale();
        if (amount < 0.0 && !silent) {
            MessageBuilder.create(this.plugin).locale(locale).prefix().message((MessageKey)CommandMessage.MANA_AT_LEAST_ZERO, new String[0]).send(issuer);
        }
        if (!(!((manaToSet = amount) > user.getMaxMana()) || allowOverMax && Traits.MAX_MANA.optionBoolean("allow_overflow", false))) {
            manaToSet = user.getMaxMana();
        }
        user.setMana(manaToSet);
        if (!silent) {
            MessageBuilder.create(this.plugin).locale(locale).prefix().message((MessageKey)CommandMessage.MANA_SET_SET, "amount", NumberUtil.format2(manaToSet), "player", user.getUsername()).send(issuer);
        }
    }
}

