/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.api.implementation;

import dev.aurelium.auraskills.api.config.ConfigNode;
import dev.aurelium.auraskills.configurate.ConfigurationNode;
import dev.aurelium.auraskills.configurate.serialize.SerializationException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class ApiConfigNode
implements ConfigNode {
    private final ConfigurationNode backing;

    public ApiConfigNode(ConfigurationNode backing) {
        this.backing = backing;
    }

    public static ConfigNode toApi(ConfigurationNode configurationNode) {
        return new ApiConfigNode(configurationNode);
    }

    public ConfigurationNode getBacking() {
        return this.backing;
    }

    @Override
    @Nullable
    public Object key() {
        return this.backing.key();
    }

    @Override
    @Nullable
    public ConfigNode parent() {
        return ApiConfigNode.toApi(this.backing.parent());
    }

    @Override
    public ConfigNode node(Object ... path) {
        return ApiConfigNode.toApi(this.backing.node(path));
    }

    @Override
    public ConfigNode node(Iterable<?> path) {
        return ApiConfigNode.toApi(this.backing.node(path));
    }

    @Override
    public boolean hasChild(Object ... path) {
        return this.backing.hasChild(path);
    }

    @Override
    public boolean hasChild(Iterable<?> path) {
        return this.backing.hasChild(path);
    }

    @Override
    public boolean virtual() {
        return this.backing.virtual();
    }

    @Override
    public boolean isNull() {
        return this.backing.isNull();
    }

    @Override
    public boolean isList() {
        return this.backing.isList();
    }

    @Override
    public boolean isMap() {
        return this.backing.isMap();
    }

    @Override
    public boolean empty() {
        return this.backing.empty();
    }

    @Override
    public List<? extends ConfigNode> childrenList() {
        ArrayList<ConfigNode> nodes = new ArrayList<ConfigNode>();
        for (ConfigurationNode configurationNode : this.backing.childrenList()) {
            nodes.add(ApiConfigNode.toApi(configurationNode));
        }
        return nodes;
    }

    @Override
    public Map<Object, ? extends ConfigNode> childrenMap() {
        ConcurrentHashMap<Object, ConfigNode> nodes = new ConcurrentHashMap<Object, ConfigNode>();
        for (Map.Entry<Object, ? extends ConfigurationNode> entry : this.backing.childrenMap().entrySet()) {
            nodes.put(entry.getKey(), ApiConfigNode.toApi(entry.getValue()));
        }
        return nodes;
    }

    @Override
    @Nullable
    public <V> V get(Class<V> type) {
        try {
            return this.backing.get(type);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <V> V get(Class<V> type, V def) {
        try {
            return this.backing.get(type, def);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <V> V get(Class<V> type, Supplier<V> defSupplier) {
        try {
            return this.backing.get(type, defSupplier);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nullable
    public Object get(Type type) {
        try {
            return this.backing.get(type);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object get(Type type, Object def) {
        try {
            return this.backing.get(type, def);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object get(Type type, Supplier<?> defSupplier) {
        try {
            return this.backing.get(type, defSupplier);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nullable
    public <V> List<V> getList(Class<V> type) {
        try {
            return this.backing.getList(type);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <V> List<V> getList(Class<V> elementType, List<V> def) {
        try {
            return this.backing.getList(elementType, def);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <V> List<V> getList(Class<V> elementType, Supplier<List<V>> defSupplier) {
        try {
            return this.backing.getList(elementType, defSupplier);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nullable
    public String getString() {
        return this.backing.getString();
    }

    @Override
    public String getString(String def) {
        return this.backing.getString(def);
    }

    @Override
    public float getFloat() {
        return this.backing.getFloat();
    }

    @Override
    public float getFloat(float def) {
        return this.backing.getFloat(def);
    }

    @Override
    public double getDouble() {
        return this.backing.getDouble();
    }

    @Override
    public double getDouble(double def) {
        return this.backing.getDouble(def);
    }

    @Override
    public int getInt() {
        return this.backing.getInt();
    }

    @Override
    public int getInt(int def) {
        return this.backing.getInt(def);
    }

    @Override
    public long getLong() {
        return this.backing.getLong();
    }

    @Override
    public long getLong(long def) {
        return this.backing.getLong(def);
    }

    @Override
    public boolean getBoolean() {
        return this.backing.getBoolean();
    }

    @Override
    public boolean getBoolean(boolean def) {
        return this.backing.getBoolean(false);
    }

    @Override
    public ConfigNode set(@Nullable Object value) {
        try {
            return ApiConfigNode.toApi(this.backing.set(value));
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <V> ConfigNode set(Class<V> type, @Nullable V value) {
        try {
            return ApiConfigNode.toApi(this.backing.set(type, value));
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ConfigNode set(Type type, @Nullable Object value) {
        try {
            return ApiConfigNode.toApi(this.backing.set(type, value));
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <V> ConfigNode setList(Class<V> elementType, @Nullable List<V> items) {
        try {
            return ApiConfigNode.toApi(this.backing.setList(elementType, items));
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nullable
    public Object raw() {
        return this.backing.raw();
    }

    @Override
    public ConfigNode raw(Object value) {
        return ApiConfigNode.toApi(this.backing.raw(value));
    }

    @Override
    @Nullable
    public Object rawScalar() {
        return this.backing.rawScalar();
    }

    @Override
    public ConfigNode from(ConfigNode other) {
        return ApiConfigNode.toApi(this.backing.from(((ApiConfigNode)other).backing));
    }

    @Override
    public ConfigNode mergeFrom(ConfigNode other) {
        return ApiConfigNode.toApi(this.backing.mergeFrom(((ApiConfigNode)other).backing));
    }

    @Override
    public boolean removeChild(Object key) {
        return this.backing.removeChild(key);
    }

    @Override
    public ConfigNode appendListNode() {
        return ApiConfigNode.toApi(this.backing.appendListNode());
    }

    @Override
    public ConfigNode copy() {
        return ApiConfigNode.toApi(this.backing.copy());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiConfigNode that = (ApiConfigNode)o;
        return Objects.equals(this.backing, that.backing);
    }

    public int hashCode() {
        return Objects.hashCode(this.backing);
    }
}

