/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.antiafk;

import dev.aurelium.auraskills.common.antiafk.CheckData;
import dev.aurelium.auraskills.common.ref.LocationRef;
import dev.aurelium.auraskills.common.ref.PlayerRef;
import java.util.Objects;
import java.util.function.ToDoubleBiFunction;
import org.jetbrains.annotations.Nullable;

public final class PositionHandler {
    private final double maxDistance;
    private final int minCount;
    private final ToDoubleBiFunction<LocationRef, LocationRef> distanceSquared;

    public PositionHandler(double maxDistance, int minCount, ToDoubleBiFunction<LocationRef, LocationRef> distanceSquared) {
        this.maxDistance = maxDistance;
        this.minCount = minCount;
        this.distanceSquared = distanceSquared;
    }

    public boolean failsCheck(CheckData data, PlayerRef player) {
        @Nullable LocationRef prevLoc = data.getCache("previous_location", LocationRef.class, null);
        LocationRef currentLoc = player.getLocation();
        data.setCache("previous_location", currentLoc);
        if (prevLoc == null) {
            return false;
        }
        if (!Objects.equals(currentLoc.getWorldName().orElse(null), prevLoc.getWorldName().orElse(null))) {
            data.resetCount();
            return false;
        }
        if (this.distanceSquared.applyAsDouble(currentLoc, prevLoc) <= this.maxDistance * this.maxDistance) {
            data.incrementCount();
        } else {
            data.resetCount();
        }
        return data.getCount() > this.minCount;
    }
}

