/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.antiafk;

import dev.aurelium.auraskills.common.antiafk.CheckData;
import dev.aurelium.auraskills.common.ref.PlayerRef;
import java.util.function.ToDoubleFunction;

public class FacingHandler {
    private final int minCount;
    private final ToDoubleFunction<PlayerRef> yawProvider;
    private final ToDoubleFunction<PlayerRef> pitchProvider;

    public FacingHandler(int minCount, ToDoubleFunction<PlayerRef> yawProvider, ToDoubleFunction<PlayerRef> pitchProvider) {
        this.minCount = minCount;
        this.yawProvider = yawProvider;
        this.pitchProvider = pitchProvider;
    }

    public boolean failsCheck(CheckData data, PlayerRef ref) {
        float prevYaw = data.getCache("previous_yaw", Float.class, Float.valueOf(-1.0f)).floatValue();
        float prevPitch = data.getCache("previous_pitch", Float.class, Float.valueOf(-1.0f)).floatValue();
        float currentYaw = (float)this.yawProvider.applyAsDouble(ref);
        float currentPitch = (float)this.pitchProvider.applyAsDouble(ref);
        data.setCache("previous_yaw", Float.valueOf(currentYaw));
        data.setCache("previous_pitch", Float.valueOf(currentPitch));
        if (prevYaw == -1.0f || prevPitch == -1.0f) {
            return false;
        }
        if (prevYaw == currentYaw && prevPitch == currentPitch) {
            data.incrementCount();
        } else {
            data.resetCount();
        }
        return data.getCount() >= this.minCount;
    }
}

