/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.ability;

import dev.aurelium.auraskills.api.ability.Ability;
import dev.aurelium.auraskills.api.ability.AbilityProvider;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.common.ability.AbilityManager;
import dev.aurelium.auraskills.common.ability.LoadedAbility;
import dev.aurelium.auraskills.common.message.MessageProvider;
import dev.aurelium.auraskills.common.registry.OptionSupplier;
import dev.aurelium.auraskills.common.util.data.OptionProvider;
import java.util.Locale;

public class AbilitySupplier
extends OptionSupplier<Ability>
implements AbilityProvider {
    private final AbilityManager abilityManager;
    private final MessageProvider messageProvider;

    public AbilitySupplier(AbilityManager abilityManager, MessageProvider messageProvider) {
        this.abilityManager = abilityManager;
        this.messageProvider = messageProvider;
    }

    private LoadedAbility get(Ability ability) {
        return this.abilityManager.getAbility(ability);
    }

    @Override
    public Skill getSkill(Ability ability) {
        return this.get(ability).skill();
    }

    @Override
    public String getDisplayName(Ability ability, Locale locale, boolean formatted) {
        return this.messageProvider.getAbilityDisplayName(ability, locale, formatted);
    }

    @Override
    public String getDescription(Ability ability, Locale locale, boolean formatted) {
        return this.messageProvider.getAbilityDescription(ability, locale, formatted);
    }

    @Override
    public String getInfo(Ability ability, Locale locale, boolean formatted) {
        return this.messageProvider.getAbilityInfo(ability, locale, formatted);
    }

    @Override
    public boolean isEnabled(Ability ability) {
        if (!this.abilityManager.isLoaded(ability)) {
            return false;
        }
        return this.get(ability).config().enabled();
    }

    @Override
    public double getBaseValue(Ability ability) {
        return this.get(ability).config().baseValue();
    }

    @Override
    public double getSecondaryBaseValue(Ability ability) {
        return this.get(ability).config().secondaryBaseValue();
    }

    @Override
    public double getValue(Ability ability, int level) {
        if (level <= 0) {
            return 0.0;
        }
        return this.getBaseValue(ability) + this.getValuePerLevel(ability) * (double)(level - 1);
    }

    @Override
    public double getValuePerLevel(Ability ability) {
        return this.get(ability).config().valuePerLevel();
    }

    @Override
    public double getSecondaryValuePerLevel(Ability ability) {
        return this.get(ability).config().secondaryValuePerLevel();
    }

    @Override
    public double getSecondaryValue(Ability ability, int level) {
        return this.getSecondaryBaseValue(ability) + this.getSecondaryValuePerLevel(ability) * (double)(level - 1);
    }

    @Override
    public int getUnlock(Ability ability) {
        return this.get(ability).config().unlock();
    }

    @Override
    public int getLevelUp(Ability ability) {
        return this.get(ability).config().levelUp();
    }

    @Override
    public int getMaxLevel(Ability ability) {
        return this.get(ability).config().maxLevel();
    }

    @Override
    public OptionProvider getOptions(Ability type) {
        return this.get(type).config();
    }

    @Override
    public boolean isLoaded(Ability type) {
        return this.abilityManager.isLoaded(type);
    }
}

