/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.util;

import dev.aurelium.auraskills.api.item.ItemContext;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.item.BukkitPotionType;
import dev.aurelium.auraskills.bukkit.util.ItemUtils;
import dev.aurelium.auraskills.bukkit.util.VersionUtils;
import dev.aurelium.auraskills.common.util.PlatformUtil;
import dev.aurelium.auraskills.common.util.data.Validate;
import dev.aurelium.auraskills.configurate.CommentedConfigurationNode;
import dev.aurelium.auraskills.configurate.ConfigurationNode;
import dev.aurelium.auraskills.configurate.serialize.SerializationException;
import dev.aurelium.auraskills.nbtapi.NBT;
import dev.aurelium.auraskills.nbtapi.iface.ReadWriteNBT;
import dev.aurelium.auraskills.slate.context.ContextGroup;
import dev.aurelium.auraskills.slate.inv.content.SlotPos;
import dev.aurelium.auraskills.slate.menu.ActiveMenu;
import dev.aurelium.auraskills.slate.position.FixedPosition;
import dev.aurelium.auraskills.slate.position.GroupPosition;
import dev.aurelium.auraskills.slate.position.PositionProvider;
import dev.aurelium.auraskills.slate.util.SkullCreator;
import dev.aurelium.auraskills.slate.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurateItemParser {
    private final AuraSkills plugin;

    public ConfigurateItemParser(AuraSkills plugin) {
        this.plugin = plugin;
    }

    public ItemStack parseItem(ConfigurationNode config) {
        return this.parseItem(config, new ArrayList<String>());
    }

    public ItemStack parseItem(ConfigurationNode config, List<String> excludedKeys) {
        ItemStack item = this.parseBaseItem(config, excludedKeys);
        this.parseDisplayNameAndLore(item, config);
        return item;
    }

    public List<ItemStack> parseMultipleItems(ConfigurationNode config) throws SerializationException {
        if (config.node("materials").virtual()) {
            return List.of(this.parseBaseItem(config));
        }
        List<String> materialList = config.node("materials").getList(String.class);
        if (materialList == null) {
            return List.of(this.parseBaseItem(config));
        }
        ArrayList<ItemStack> parsedItems = new ArrayList<ItemStack>();
        for (String materialString : materialList) {
            ItemStack item = this.parseMaterialString(materialString);
            item = this.parseItemMeta(item, config, new ArrayList<String>());
            this.parseDisplayNameAndLore(item, config);
            parsedItems.add(item);
        }
        return parsedItems;
    }

    public ItemStack parseBaseItem(ConfigurationNode config) {
        return this.parseBaseItem(config, new ArrayList<String>());
    }

    public ItemStack parseBaseItem(ConfigurationNode config, List<String> excludedKeys) {
        ItemStack item;
        String key = config.node("key").getString();
        if (key != null && (item = this.parseItemKey(key)) != null) {
            return item;
        }
        String materialString = config.node("material").getString();
        Validate.notNull(materialString, "Item must specify a material");
        ItemStack item2 = this.parseMaterialString(materialString);
        item2 = this.parseItemMeta(item2, config, excludedKeys);
        return item2;
    }

    public ItemStack parseItemMeta(ItemStack item, ConfigurationNode config, List<String> excludedKeys) {
        ItemMeta meta;
        if (!excludedKeys.contains("amount")) {
            this.parseAmount(item, config);
        }
        if ((meta = item.getItemMeta()) == null) {
            return item;
        }
        if (config.hasChild("enchantments") && !excludedKeys.contains("enchantments")) {
            this.parseEnchantments(item, config);
        }
        if (config.hasChild("potion_data") && !excludedKeys.contains("potion_data")) {
            this.parsePotionData(item, config.node("potion_data"));
        }
        if (config.hasChild("custom_effects") && !excludedKeys.contains("custom_effects")) {
            this.parseCustomEffects(config, item);
        }
        if (config.node("glow").getBoolean(false)) {
            this.parseGlow(item);
        }
        if (!config.node("nbt").virtual() && !excludedKeys.contains("nbt")) {
            item = this.parseNBT(item, config.node("nbt"));
        }
        if (!config.node("flags").virtual() && !excludedKeys.contains("flags")) {
            this.parseFlags(config, item);
        }
        if (!config.node("durability").virtual() && !excludedKeys.contains("durability")) {
            this.parseDurability(config, item);
        }
        this.parseItemModel(config, item);
        this.parseCustomModelData(config, item);
        this.parseHideTooltip(config, item);
        ConfigurationNode skullMetaSection = config.node("skull_meta");
        if (!skullMetaSection.virtual() && !excludedKeys.contains("skull_meta")) {
            this.parseSkullMeta(item, item.getItemMeta(), skullMetaSection);
        }
        return item;
    }

    public ItemStack parseNBT(ItemStack item, ConfigurationNode config) {
        if (this.plugin.isNbtApiDisabled()) {
            return item;
        }
        if (config.isMap()) {
            this.parseNBT(item, config.childrenMap());
        } else if (config.getString() != null) {
            String nbtString = config.getString("nbt");
            this.parseNBTString(item, nbtString);
        }
        return item;
    }

    public void parseDisplayNameAndLore(ItemStack item, ConfigurationNode config) {
        List<String> lore;
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        String displayName = this.parseDisplayName(config);
        if (displayName != null) {
            meta.setDisplayName(displayName);
        }
        if (!(lore = this.parseLore(config)).isEmpty()) {
            meta.setLore(lore);
        }
        item.setItemMeta(meta);
    }

    @Nullable
    private ItemStack parseItemKey(String key) {
        return this.plugin.getItemRegistry().getItem(NamespacedId.fromDefaultWithColon(key));
    }

    private void parseDurability(ConfigurationNode section, ItemStack item) {
        ItemMeta meta = this.getMeta(item);
        int durability = section.node("durability").getInt();
        if (meta instanceof Damageable) {
            Damageable damageable = (Damageable)meta;
            short maxDurability = item.getType().getMaxDurability();
            damageable.setDamage(Math.max(maxDurability - durability, maxDurability));
            item.setItemMeta(meta);
        }
    }

    private void parseFlags(ConfigurationNode section, ItemStack item) {
        try {
            ItemMeta meta = this.getMeta(item);
            List<String> flags = section.node("flags").getList(String.class, new ArrayList());
            for (String flagName : flags) {
                ItemFlag itemFlag = ItemFlag.valueOf((String)this.substituteItemFlag(flagName.toUpperCase(Locale.ROOT)));
                if (itemFlag == ItemFlag.HIDE_ATTRIBUTES && VersionUtils.isAtLeastVersion(20, 5) && !this.plugin.isMock()) {
                    meta.setAttributeModifiers(Material.IRON_SWORD.getDefaultAttributeModifiers(EquipmentSlot.HAND));
                }
                meta.addItemFlags(new ItemFlag[]{itemFlag});
            }
            item.setItemMeta(meta);
        }
        catch (SerializationException serializationException) {
            // empty catch block
        }
    }

    private String substituteItemFlag(String name) {
        if (VersionUtils.isAtLeastVersion(20, 5) && name.equals("HIDE_POTION_EFFECTS")) {
            return "HIDE_ADDITIONAL_TOOLTIP";
        }
        return name;
    }

    private void parseGlow(ItemStack item) {
        ItemMeta meta = this.getMeta(item);
        meta.addEnchant(Enchantment.MENDING, 1, true);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        item.setItemMeta(meta);
    }

    private void parseCustomEffects(ConfigurationNode section, ItemStack item) {
        PotionMeta potionMeta = (PotionMeta)this.getMeta(item);
        for (ConfigurationNode configurationNode : section.node("custom_effects").childrenList()) {
            String effectName = configurationNode.node("type").getString("SPEED");
            PotionEffectType type = PotionEffectType.getByName((String)effectName);
            if (type != null) {
                int duration = configurationNode.node("duration").getInt();
                int amplifier = configurationNode.node("amplifier").getInt();
                potionMeta.addCustomEffect(new PotionEffect(type, duration, amplifier), true);
                potionMeta.setColor(type.getColor());
                continue;
            }
            throw new IllegalArgumentException("Invalid potion effect type " + effectName);
        }
        item.setItemMeta((ItemMeta)potionMeta);
    }

    public void parsePotionData(ItemStack item, ConfigurationNode node) {
        ItemMeta meta = this.getMeta(item);
        if (!(meta instanceof PotionMeta)) {
            return;
        }
        PotionMeta potionMeta = (PotionMeta)meta;
        String typeName = node.node("type").getString("WATER").toUpperCase(Locale.ROOT);
        PotionType potionType = PotionType.valueOf((String)this.substitutePotionType(typeName));
        boolean extended = node.node("extended").getBoolean(false);
        boolean upgraded = node.node("upgraded").getBoolean(false);
        BukkitPotionType bukkitPotionType = new BukkitPotionType(potionType, extended, upgraded);
        bukkitPotionType.applyToMeta(potionMeta);
        item.setItemMeta((ItemMeta)potionMeta);
    }

    private String substitutePotionType(String name) {
        if (!VersionUtils.isAtLeastVersion(20, 5)) {
            return name;
        }
        return switch (name) {
            case "INSTANT_DAMAGE" -> "HARMING";
            case "INSTANT_HEAL" -> "HEALING";
            case "REGEN" -> "REGENERATION";
            case "JUMP" -> "LEAPING";
            case "SPEED" -> "SWIFTNESS";
            default -> name;
        };
    }

    private void parseEnchantments(ItemStack item, ConfigurationNode section) {
        try {
            ItemMeta meta = this.getMeta(item);
            List<String> enchantmentStrings = section.node("enchantments").getList(String.class, new ArrayList());
            for (String enchantmentEntry : enchantmentStrings) {
                String[] splitEntry = enchantmentEntry.split(" ");
                String enchantmentName = splitEntry[0];
                int level = 1;
                if (splitEntry.length > 1) {
                    level = NumberUtil.toInt(splitEntry[1], 1);
                }
                if (ItemUtils.getAndAddEnchant(enchantmentName, level, item, meta)) continue;
                throw new IllegalArgumentException("Invalid enchantment name " + enchantmentName);
            }
        }
        catch (SerializationException serializationException) {
            // empty catch block
        }
    }

    public SlotPos parsePosition(String input) {
        String[] splitInput = input.split(",", 2);
        if (splitInput.length == 2) {
            int row = Integer.parseInt(splitInput[0]);
            int column = Integer.parseInt(splitInput[1]);
            return SlotPos.of(row, column);
        }
        int slot = Integer.parseInt(input);
        int row = slot / 9;
        int column = slot % 9;
        return SlotPos.of(row, column);
    }

    public ConfigurationNode parseItemContext(ItemContext itemContext) throws SerializationException {
        CommentedConfigurationNode config = CommentedConfigurationNode.root();
        for (Map.Entry<String, Object> entry : itemContext.getMap().entrySet()) {
            config.node(entry.getKey()).set(entry.getValue());
        }
        return config;
    }

    @Nullable
    public PositionProvider parsePositionProvider(ConfigurationNode config, ActiveMenu activeMenu, String templateName) {
        String pos = config.node("pos").getString();
        if (pos != null) {
            SlotPos slotPos = this.parsePosition(pos);
            return new FixedPosition(slotPos);
        }
        if (!config.node("group").virtual()) {
            String groupName = config.node("group").getString("");
            ContextGroup contextGroup = activeMenu.getContextGroups(templateName).get(groupName);
            if (contextGroup != null) {
                int order = config.node("order").getInt();
                return new GroupPosition(contextGroup, order);
            }
        }
        return null;
    }

    private ItemStack parseMaterialString(String materialString) {
        String materialName = materialString.toUpperCase(Locale.ROOT);
        Material material = this.parseMaterial(materialName);
        if (material == null) {
            throw new IllegalArgumentException("Unknown material " + materialString);
        }
        if (!material.isItem()) {
            return new ItemStack(Material.GRAY_DYE);
        }
        ItemStack item = new ItemStack(material);
        return item;
    }

    @NotNull
    public ItemMeta getMeta(ItemStack item) {
        return Objects.requireNonNull(item.getItemMeta());
    }

    @Nullable
    public String parseDisplayName(ConfigurationNode section) {
        if (!section.node("display_name").virtual()) {
            PlatformUtil util = this.plugin.getPlatformUtil();
            return util.toString(util.toComponent(section.node("display_name").getString()));
        }
        return null;
    }

    @NotNull
    public List<String> parseLore(ConfigurationNode section) {
        try {
            List<String> lore = section.node("lore").getList(String.class, new ArrayList());
            ArrayList<String> formattedLore = new ArrayList<String>();
            for (String line : lore) {
                PlatformUtil util = this.plugin.getPlatformUtil();
                line = util.toString(util.toComponent(line));
                formattedLore.add(line);
            }
            return formattedLore;
        }
        catch (SerializationException e) {
            return new ArrayList<String>();
        }
    }

    private void parseNBT(ItemStack item, Map<Object, ? extends ConfigurationNode> map) {
        NBT.modify(item, nbt -> this.applyMapToNBT((ReadWriteNBT)nbt, map));
    }

    private void applyMapToNBT(ReadWriteNBT item, Map<Object, ? extends ConfigurationNode> map) {
        for (Map.Entry<Object, ? extends ConfigurationNode> entry : map.entrySet()) {
            String key;
            Object keyObj = entry.getKey();
            Object value = entry.getValue().raw();
            if (!(keyObj instanceof String) || (key = (String)keyObj).equals("CustomModelData")) continue;
            if (value instanceof ConfigurationNode) {
                ConfigurationNode childNode = (ConfigurationNode)value;
                this.applyMapToNBT(item.getOrCreateCompound(key), childNode.childrenMap());
                continue;
            }
            if (value instanceof Integer) {
                item.setInteger(key, (int)((Integer)value));
                continue;
            }
            if (value instanceof Double) {
                item.setDouble(key, (double)((Double)value));
                continue;
            }
            if (value instanceof Boolean) {
                item.setBoolean(key, (boolean)((Boolean)value));
                continue;
            }
            if (!(value instanceof String)) continue;
            item.setString(key, (String)value);
        }
    }

    private void parseNBTString(ItemStack item, String nbtString) {
        ReadWriteNBT container = NBT.parseNBT(nbtString);
        NBT.modify(item, nbt -> nbt.mergeCompound(container));
    }

    @Nullable
    protected Material parseMaterial(String name) {
        if (name.equals("SCUTE") && VersionUtils.isAtLeastVersion(20, 5)) {
            return Material.TURTLE_SCUTE;
        }
        if (name.equals("TURTLE_SCUTE") && !VersionUtils.isAtLeastVersion(20, 5)) {
            return Material.valueOf((String)"SCUTE");
        }
        return Material.getMaterial((String)name);
    }

    private void parseSkullMeta(ItemStack item, ItemMeta meta, ConfigurationNode section) {
        String placeholder;
        String url;
        String base64;
        if (!(meta instanceof SkullMeta)) {
            return;
        }
        SkullMeta skullMeta = (SkullMeta)meta;
        String uuid = section.node("uuid").getString();
        if (uuid != null) {
            UUID id = UUID.fromString(uuid);
            skullMeta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)id));
            item.setItemMeta(meta);
        }
        if ((base64 = section.node("base64").getString()) != null) {
            SkullCreator.itemWithBase64(item, base64);
        }
        if ((url = section.node("url").getString()) != null) {
            SkullCreator.itemWithUrl(item, url);
        }
        if (VersionUtils.isAtLeastVersion(14) && (placeholder = section.node("placeholder_uuid").getString()) != null) {
            PersistentDataContainer container = meta.getPersistentDataContainer();
            NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "skull_placeholder_uuid");
            container.set(key, PersistentDataType.STRING, (Object)placeholder);
            item.setItemMeta(meta);
        }
    }

    private void parseAmount(ItemStack item, ConfigurationNode section) {
        int amount = section.node("amount").getInt(1);
        item.setAmount(amount);
    }

    private void parseCustomModelData(ConfigurationNode config, ItemStack item) {
        if (!config.node("custom_model_data").virtual()) {
            int data = config.node("custom_model_data").getInt();
            ItemMeta meta = this.getMeta(item);
            meta.setCustomModelData(Integer.valueOf(data));
            item.setItemMeta(meta);
        } else if (!config.node("nbt").node("CustomModelData").virtual()) {
            int data = config.node("nbt").node("CustomModelData").getInt();
            ItemMeta meta = this.getMeta(item);
            meta.setCustomModelData(Integer.valueOf(data));
            item.setItemMeta(meta);
        }
    }

    private void parseItemModel(ConfigurationNode config, ItemStack item) {
        if (!config.node("item_model").empty() && VersionUtil.isAtLeastVersion(21, 2)) {
            String model = config.node("item_model").getString("");
            ItemMeta meta = this.getMeta(item);
            meta.setItemModel(NamespacedKey.fromString((String)model));
            item.setItemMeta(meta);
        }
    }

    public void parseHideTooltip(ConfigurationNode config, ItemStack item) {
        if (!config.node("hide_tooltip").virtual()) {
            this.parseHideTooltipNode(config.node("hide_tooltip"), item);
        }
    }

    public void parseHideTooltipNode(ConfigurationNode tooltipNode, ItemStack item) {
        boolean hideTooltip = tooltipNode.getBoolean();
        ItemMeta meta = this.getMeta(item);
        if (VersionUtils.isAtLeastVersion(20, 5)) {
            meta.setHideTooltip(hideTooltip);
        }
        item.setItemMeta(meta);
    }
}

