/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.user;

import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.ref.BukkitPlayerRef;
import dev.aurelium.auraskills.bukkit.user.BukkitUser;
import dev.aurelium.auraskills.common.ref.PlayerRef;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.user.UserManager;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class BukkitUserManager
extends UserManager {
    private final AuraSkills plugin;

    public BukkitUserManager(AuraSkills plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    @NotNull
    public User getUser(Player player) {
        User user = (User)this.playerDataMap.get(player.getUniqueId());
        if (user != null) {
            return user;
        }
        return this.createNewUser(player.getUniqueId(), BukkitPlayerRef.wrap(player));
    }

    @Override
    public User instantiateUser(UUID uuid, PlayerRef ref) {
        return new BukkitUser(uuid, ref != null ? BukkitPlayerRef.unwrap(ref) : null, this.plugin);
    }

    @Override
    public List<User> getOnlineUsers() {
        ArrayList<User> online = new ArrayList<User>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            User user = (User)this.playerDataMap.get(player.getUniqueId());
            if (user == null) continue;
            online.add(user);
        }
        return online;
    }
}

