/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.trait;

import dev.aurelium.auraskills.api.bukkit.BukkitTraitHandler;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.trait.TraitHandler;
import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.trait.AnvilDiscountTrait;
import dev.aurelium.auraskills.bukkit.trait.AttackDamageTrait;
import dev.aurelium.auraskills.bukkit.trait.CritChanceTrait;
import dev.aurelium.auraskills.bukkit.trait.CritDamageTrait;
import dev.aurelium.auraskills.bukkit.trait.DamageReductionTrait;
import dev.aurelium.auraskills.bukkit.trait.DoubleDropTrait;
import dev.aurelium.auraskills.bukkit.trait.ExperienceBonusTrait;
import dev.aurelium.auraskills.bukkit.trait.GatheringLuckTraits;
import dev.aurelium.auraskills.bukkit.trait.HealthRegenTraits;
import dev.aurelium.auraskills.bukkit.trait.HpTrait;
import dev.aurelium.auraskills.bukkit.trait.LuckTrait;
import dev.aurelium.auraskills.bukkit.trait.ManaRegenTrait;
import dev.aurelium.auraskills.bukkit.trait.MaxManaTrait;
import dev.aurelium.auraskills.bukkit.trait.MovementSpeedTrait;
import dev.aurelium.auraskills.bukkit.user.BukkitUser;
import dev.aurelium.auraskills.common.trait.TraitManager;
import dev.aurelium.auraskills.common.user.User;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class BukkitTraitManager
extends TraitManager {
    private final AuraSkills plugin;
    private final Map<Class<?>, BukkitTraitHandler> traitImpls = new ConcurrentHashMap();

    public BukkitTraitManager(AuraSkills plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    public void registerTraitImplementations() {
        this.registerTraitImpl(new HpTrait(this.plugin));
        this.registerTraitImpl(new HealthRegenTraits(this.plugin));
        this.registerTraitImpl(new ManaRegenTrait(this.plugin));
        this.registerTraitImpl(new LuckTrait(this.plugin));
        this.registerTraitImpl(new DoubleDropTrait(this.plugin));
        this.registerTraitImpl(new AttackDamageTrait(this.plugin));
        this.registerTraitImpl(new ExperienceBonusTrait(this.plugin));
        this.registerTraitImpl(new AnvilDiscountTrait(this.plugin));
        this.registerTraitImpl(new MaxManaTrait(this.plugin));
        this.registerTraitImpl(new DamageReductionTrait(this.plugin));
        this.registerTraitImpl(new CritChanceTrait(this.plugin));
        this.registerTraitImpl(new CritDamageTrait(this.plugin));
        this.registerTraitImpl(new MovementSpeedTrait(this.plugin));
        this.registerTraitImpl(new GatheringLuckTraits(this.plugin));
    }

    public void registerTraitImpl(BukkitTraitHandler bukkitTrait) {
        this.traitImpls.put(bukkitTrait.getClass(), bukkitTrait);
        if (bukkitTrait instanceof Listener) {
            Listener eventListener = (Listener)bukkitTrait;
            Bukkit.getPluginManager().registerEvents(eventListener, (Plugin)this.plugin);
        }
    }

    public <T extends BukkitTraitHandler> T getTraitImpl(Class<T> clazz) {
        BukkitTraitHandler traitHandler = this.traitImpls.get(clazz);
        if (traitHandler != null) {
            return (T)((BukkitTraitHandler)clazz.cast(traitHandler));
        }
        throw new IllegalArgumentException("Trait implementation of type " + clazz.getSimpleName() + " not found!");
    }

    @Nullable
    public BukkitTraitHandler getTraitImpl(Trait trait) {
        for (BukkitTraitHandler traitImpl : this.traitImpls.values()) {
            for (Trait tr : traitImpl.getTraits()) {
                if (!trait.getId().equals(tr.getId())) continue;
                return traitImpl;
            }
        }
        return null;
    }

    public Collection<BukkitTraitHandler> getAllTraitImpls() {
        return this.traitImpls.values();
    }

    @Override
    public double getBaseLevel(User user, Trait trait) {
        Player player = ((BukkitUser)user).getPlayer();
        if (player == null) {
            return 0.0;
        }
        BukkitTraitHandler traitImpl = this.getTraitImpl(trait);
        if (traitImpl != null) {
            return traitImpl.getBaseLevel(player, trait);
        }
        return 0.0;
    }

    @Override
    public void registerTraitHandler(TraitHandler traitHandler) {
        if (traitHandler instanceof BukkitTraitHandler) {
            BukkitTraitHandler bukkitTraitHandler = (BukkitTraitHandler)traitHandler;
            this.registerTraitImpl(bukkitTraitHandler);
        }
    }

    @Override
    public String getMenuDisplay(Trait trait, double value, Locale locale, @Nullable NumberFormat format) {
        BukkitTraitHandler impl = this.getTraitImpl(trait);
        if (impl != null) {
            if (impl instanceof HpTrait) {
                HpTrait hpTrait = (HpTrait)impl;
                return hpTrait.getMenuDisplay(value, trait, format);
            }
            return impl.getMenuDisplay(value, trait, locale);
        }
        if (format != null) {
            return format.format(value);
        }
        return NumberUtil.format1(value);
    }
}

