/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.trait;

import dev.aurelium.auraskills.api.stat.Stats;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.trait.Traits;
import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.trait.TraitImpl;
import dev.aurelium.auraskills.bukkit.util.VersionUtils;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.evalex.EvaluationException;
import dev.aurelium.auraskills.evalex.Expression;
import dev.aurelium.auraskills.evalex.parser.ParseException;
import java.util.Locale;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.view.AnvilView;
import org.jetbrains.annotations.Nullable;

public class AnvilDiscountTrait
extends TraitImpl {
    @Nullable
    private Expression formula;

    AnvilDiscountTrait(AuraSkills plugin) {
        super(plugin, Traits.ANVIL_DISCOUNT);
    }

    @Override
    public double getBaseLevel(Player player, Trait trait) {
        return 0.0;
    }

    @Override
    public String getMenuDisplay(double value, Trait trait, Locale locale) {
        return NumberUtil.format1(this.getDiscount(value) * 100.0) + "%";
    }

    @Override
    public boolean displayMatchesValue() {
        return false;
    }

    @EventHandler
    public void onAnvilPrepare(PrepareAnvilEvent event) {
        if (!Traits.ANVIL_DISCOUNT.isEnabled()) {
            return;
        }
        User user = null;
        for (HumanEntity entity : event.getViewers()) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            if (this.plugin.getWorldManager().isInDisabledWorld(player.getLocation())) {
                return;
            }
            User checkedUser = this.plugin.getUser(player);
            if (user == null) {
                user = checkedUser;
                continue;
            }
            if (!(user.getStatLevel(Stats.WISDOM) < checkedUser.getStatLevel(Stats.WISDOM))) continue;
            user = checkedUser;
        }
        if (user != null) {
            double traitValue = user.getEffectiveTraitLevel(Traits.ANVIL_DISCOUNT);
            if (VersionUtils.isAtLeastVersion(21, 1)) {
                AnvilView view = event.getView();
                int repairCost = view.getRepairCost();
                int cost = (int)Math.round((double)repairCost * (1.0 - this.getDiscount(traitValue)));
                if (cost > 0) {
                    view.setRepairCost(cost);
                } else {
                    view.setRepairCost(1);
                }
            } else {
                AnvilInventory anvil = event.getInventory();
                int cost = (int)Math.round((double)anvil.getRepairCost() * (1.0 - this.getDiscount(traitValue)));
                if (cost > 0) {
                    anvil.setRepairCost(cost);
                } else {
                    anvil.setRepairCost(1);
                }
            }
        }
    }

    public void resetFormula() {
        this.formula = null;
    }

    private double getDiscount(double traitValue) {
        try {
            if (this.formula == null) {
                this.formula = new Expression(Traits.ANVIL_DISCOUNT.optionString("formula"));
            }
            this.formula.with("value", traitValue);
            return this.formula.evaluate().getNumberValue().doubleValue();
        }
        catch (EvaluationException | ParseException | UnsupportedOperationException e) {
            this.plugin.logger().warn("Failed to evaluate formula for trait auraskills/anvil_discount: " + e.getMessage());
            return -1.0 * Math.pow(1.025, -1.0 * traitValue) + 1.0;
        }
    }
}

