/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.storage;

import dev.aurelium.auraskills.bukkit.util.VersionUtils;
import dev.aurelium.auraskills.nbtapi.NBT;
import dev.aurelium.auraskills.nbtapi.iface.NBTFileHandle;
import dev.aurelium.auraskills.nbtapi.iface.ReadWriteNBT;
import dev.aurelium.auraskills.nbtapi.iface.ReadWriteNBTCompoundList;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public class Uninstaller {
    public void removeAttributes(CommandSender sender) {
        File playerDataFolder = new File(((World)Bukkit.getWorlds().get(0)).getWorldFolder(), "playerdata");
        int successful = 0;
        int error = 0;
        int total = 0;
        for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
            if (player.isOnline()) continue;
            ++total;
            File playerFile = new File(playerDataFolder, String.valueOf(player.getUniqueId()) + ".dat");
            if (!playerFile.exists() || !playerFile.canWrite()) continue;
            try {
                NBTFileHandle nbtFile = NBT.getFileHandle(playerFile);
                if (VersionUtils.isAtLeastVersion(21)) {
                    if (!this.removePlayer(nbtFile)) continue;
                    ++successful;
                    continue;
                }
                if (!this.removeLegacyPlayer(nbtFile)) continue;
                ++successful;
            }
            catch (Exception e) {
                ++error;
            }
        }
        sender.sendMessage("Searched " + total + " offline players. Successfully removed attributes from " + successful + " players. Failed to remove on " + error + " players.");
    }

    private boolean removePlayer(NBTFileHandle nbtFile) throws IOException {
        ReadWriteNBTCompoundList compoundList = nbtFile.getCompoundList("attributes");
        if (compoundList == null) {
            return false;
        }
        AtomicBoolean save = new AtomicBoolean(false);
        for (ReadWriteNBT listCompound : compoundList.subList(0, compoundList.size())) {
            ReadWriteNBTCompoundList modifierList = listCompound.getCompoundList("modifiers");
            if (modifierList == null) continue;
            modifierList.removeIf(modifier -> {
                String id = modifier.getString("id");
                if (id != null && id.startsWith("auraskills:")) {
                    save.set(true);
                    return true;
                }
                return false;
            });
            if (!modifierList.isEmpty()) continue;
            listCompound.removeKey("modifiers");
        }
        if (save.get()) {
            nbtFile.save();
            return true;
        }
        return false;
    }

    private boolean removeLegacyPlayer(NBTFileHandle nbtFile) throws IOException {
        ReadWriteNBTCompoundList compoundList = nbtFile.getCompoundList("Attributes");
        if (compoundList == null) {
            return false;
        }
        AtomicBoolean save = new AtomicBoolean(false);
        block13: for (ReadWriteNBT listCompound : compoundList.subList(0, compoundList.size())) {
            switch (listCompound.getString("Name")) {
                case "generic.maxHealth": 
                case "minecraft:generic.max_health": {
                    ReadWriteNBTCompoundList modifierList = listCompound.getCompoundList("Modifiers");
                    if (modifierList == null) continue block13;
                    modifierList.removeIf(modifier -> {
                        if (modifier.getString("Name").equals("skillsHealth")) {
                            save.set(true);
                            return true;
                        }
                        return false;
                    });
                    if (!modifierList.isEmpty()) continue block13;
                    listCompound.removeKey("Modifiers");
                    break;
                }
                case "generic.luck": 
                case "minecraft:generic.luck": {
                    ReadWriteNBTCompoundList modifierList = listCompound.getCompoundList("Modifiers");
                    if (modifierList == null) continue block13;
                    modifierList.removeIf(modifier -> {
                        if (modifier.getString("Name").equals("AureliumSkills-Luck")) {
                            save.set(true);
                            return true;
                        }
                        return false;
                    });
                    if (!modifierList.isEmpty()) continue block13;
                    listCompound.removeKey("Modifiers");
                    break;
                }
                case "generic.attackSpeed": 
                case "minecraft:generic.attack_speed": {
                    ReadWriteNBTCompoundList modifierList = listCompound.getCompoundList("Modifiers");
                    if (modifierList == null) break;
                    modifierList.removeIf(modifier -> {
                        if (modifier.getString("Name").equals("AureliumSkills-LightningBlade")) {
                            save.set(true);
                            return true;
                        }
                        return false;
                    });
                    if (!modifierList.isEmpty()) break;
                    listCompound.removeKey("Modifiers");
                }
            }
        }
        if (save.get()) {
            nbtFile.save();
            return true;
        }
        return false;
    }
}

