/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.source;

import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.source.LevelerContext;
import dev.aurelium.auraskills.api.source.SourceType;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.util.ItemUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;

public abstract class SourceLeveler
implements Listener {
    protected final AuraSkills plugin;
    private final SourceType sourceType;
    private final LevelerContext context;

    public SourceLeveler(AuraSkills plugin, SourceType sourceType) {
        this.plugin = plugin;
        this.sourceType = sourceType;
        this.context = new LevelerContext(plugin.getApi(), sourceType);
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }

    protected boolean disabled() {
        return !this.plugin.getSkillManager().isSourceEnabled(this.sourceType);
    }

    protected boolean failsChecks(Cancellable event, Player player, Location location, Skill skill) {
        return this.context.failsChecks(event, player, location, skill);
    }

    protected boolean failsChecks(Player player, Location location, Skill skill) {
        return this.context.failsChecks(player, location, skill);
    }

    protected boolean isDisabled(Skill skill) {
        return this.context.isDisabled(skill);
    }

    protected boolean isCancelled(Cancellable event, Skill skill) {
        return this.context.isCancelled(event, skill);
    }

    protected boolean blockLocation(Player player, Location location, Skill skill) {
        return this.context.blockLocation(player, location, skill);
    }

    protected boolean blockPlayer(Player player, Skill skill) {
        return this.context.blockPlayer(player, skill);
    }

    protected boolean failsClickChecks(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return true;
        }
        Player player = (Player)humanEntity;
        ClickType click = event.getClick();
        if (click != ClickType.LEFT && click != ClickType.RIGHT && ItemUtils.isInventoryFull(player)) {
            return true;
        }
        if (event.getResult() != Event.Result.ALLOW) {
            return true;
        }
        if (player.getItemOnCursor().getType() != Material.AIR) {
            return true;
        }
        InventoryAction action = event.getAction();
        return action != InventoryAction.PICKUP_ALL && action != InventoryAction.MOVE_TO_OTHER_INVENTORY && action != InventoryAction.PICKUP_HALF && action != InventoryAction.DROP_ALL_SLOT && action != InventoryAction.DROP_ONE_SLOT && action != InventoryAction.HOTBAR_SWAP;
    }
}

