/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.source;

import com.google.common.collect.Sets;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.source.SkillSource;
import dev.aurelium.auraskills.api.source.type.JumpingXpSource;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.source.SourceLeveler;
import dev.aurelium.auraskills.bukkit.util.CompatUtil;
import dev.aurelium.auraskills.common.source.SourceTypes;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;

public class JumpingLeveler
extends SourceLeveler {
    private final Set<UUID> prevPlayersOnGround = Sets.newConcurrentHashSet();

    public JumpingLeveler(AuraSkills plugin) {
        super(plugin, SourceTypes.JUMPING);
    }

    @EventHandler
    public void onJump(PlayerMoveEvent event) {
        if (this.disabled()) {
            return;
        }
        Player player = event.getPlayer();
        this.handleJump(player, event);
        if (player.isOnGround()) {
            this.prevPlayersOnGround.add(player.getUniqueId());
        } else {
            this.prevPlayersOnGround.remove(player.getUniqueId());
        }
    }

    private void handleJump(Player player, PlayerMoveEvent event) {
        PotionEffect effect;
        if (player.getVelocity().getY() <= 0.0) {
            return;
        }
        double jumpVelocity = 0.42f;
        if (CompatUtil.hasEffect(player, Set.of("jump", "jump_boost")) && (effect = CompatUtil.getEffect(player, Set.of("jump", "jump_boost"))) != null) {
            jumpVelocity += (double)((float)(effect.getAmplifier() + 1) * 0.1f);
        }
        if (player.getLocation().getBlock().getType() == Material.LADDER || !this.prevPlayersOnGround.contains(player.getUniqueId())) {
            return;
        }
        if (player.isOnGround() || Double.compare(player.getVelocity().getY(), jumpVelocity) != 0) {
            return;
        }
        SkillSource<JumpingXpSource> skillSource = this.plugin.getSkillManager().getSingleSourceOfType(JumpingXpSource.class);
        if (skillSource == null) {
            return;
        }
        JumpingXpSource source = skillSource.source();
        Skill skill = skillSource.skill();
        if (player.hasMetadata("skillsJumps")) {
            player.setMetadata("skillsJumps", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)(((MetadataValue)player.getMetadata("skillsJumps").get(0)).asInt() + 1)));
            if (((MetadataValue)player.getMetadata("skillsJumps").get(0)).asInt() >= source.getInterval()) {
                if (this.failsChecks((Cancellable)event, player, player.getLocation(), skill)) {
                    return;
                }
                this.plugin.getLevelManager().addXp(this.plugin.getUser(player), skill, source, source.getXp());
                player.removeMetadata("skillsJumps", (Plugin)this.plugin);
            }
        } else {
            player.setMetadata("skillsJumps", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)1));
        }
    }
}

