/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.source;

import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.source.SkillSource;
import dev.aurelium.auraskills.api.source.type.FishingXpSource;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.source.SourceLeveler;
import dev.aurelium.auraskills.common.source.SourceTypes;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class FishingLeveler
extends SourceLeveler {
    public FishingLeveler(AuraSkills plugin) {
        super(plugin, SourceTypes.FISHING);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onFish(PlayerFishEvent event) {
        if (this.disabled()) {
            return;
        }
        if (!event.getState().equals((Object)PlayerFishEvent.State.CAUGHT_FISH)) {
            return;
        }
        Entity entity = event.getCaught();
        if (!(entity instanceof Item)) {
            return;
        }
        Item itemEntity = (Item)entity;
        ItemStack item = itemEntity.getItemStack();
        Player player = event.getPlayer();
        SkillSource<FishingXpSource> skillSource = this.getSource(item);
        if (skillSource == null) {
            return;
        }
        FishingXpSource source = skillSource.source();
        Skill skill = skillSource.skill();
        if (this.failsChecks((Cancellable)event, player, itemEntity.getLocation(), skill)) {
            return;
        }
        this.plugin.getLevelManager().addXp(this.plugin.getUser(player), skill, source, source.getXp());
    }

    @Nullable
    public SkillSource<FishingXpSource> getSource(ItemStack item) {
        for (SkillSource<FishingXpSource> entry : this.plugin.getSkillManager().getSourcesOfType(FishingXpSource.class)) {
            if (!this.plugin.getItemRegistry().passesFilter(item, entry.source().getItem(), entry.skill())) continue;
            return entry;
        }
        return null;
    }
}

