/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.source;

import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.source.SkillSource;
import dev.aurelium.auraskills.api.source.type.BrewingXpSource;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.region.BukkitBlock;
import dev.aurelium.auraskills.bukkit.source.SourceLeveler;
import dev.aurelium.auraskills.common.region.BlockPosition;
import dev.aurelium.auraskills.common.source.SourceTypes;
import dev.aurelium.auraskills.common.user.User;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.BrewingStand;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.BrewEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrewingLeveler
extends SourceLeveler {
    private final Map<BlockPosition, BrewingStandData> brewingStands = new ConcurrentHashMap<BlockPosition, BrewingStandData>();

    public BrewingLeveler(AuraSkills plugin) {
        super(plugin, SourceTypes.BREWING);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBrew(BrewEvent event) {
        if (this.disabled()) {
            return;
        }
        ItemStack ingredient = event.getContents().getIngredient();
        if (ingredient == null) {
            return;
        }
        SkillSource<BrewingXpSource> skillSource = this.getSource(ingredient);
        if (skillSource == null) {
            return;
        }
        BrewingXpSource source = skillSource.source();
        Skill skill = skillSource.skill();
        if (source.getTrigger() == BrewingXpSource.BrewTriggers.TAKEOUT) {
            this.checkBrewedSlots(event);
        } else if (source.getTrigger() == BrewingXpSource.BrewTriggers.BREW) {
            if (!event.getBlock().hasMetadata("skillsBrewingStandOwner")) {
                return;
            }
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(((MetadataValue)event.getBlock().getMetadata("skillsBrewingStandOwner").get(0)).asString()));
            if (!offlinePlayer.isOnline()) {
                return;
            }
            Player player = offlinePlayer.getPlayer();
            if (player == null) {
                return;
            }
            User user = this.plugin.getUserManager().getUser(player);
            if (this.failsChecks((Cancellable)event, player, event.getBlock().getLocation(), skill)) {
                return;
            }
            this.plugin.getLevelManager().addXp(user, skill, source, source.getXp());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onTakePotionOut(InventoryClickEvent event) {
        if (this.disabled()) {
            return;
        }
        Inventory inventory = event.getClickedInventory();
        if (inventory == null) {
            return;
        }
        if (inventory.getType() != InventoryType.BREWING && !(inventory instanceof BrewerInventory)) {
            return;
        }
        int slot = event.getSlot();
        if (slot > 2) {
            return;
        }
        InventoryAction action = event.getAction();
        if (action != InventoryAction.PICKUP_ALL && action != InventoryAction.PICKUP_HALF && action != InventoryAction.PICKUP_SOME && action != InventoryAction.PICKUP_ONE && action != InventoryAction.MOVE_TO_OTHER_INVENTORY && action != InventoryAction.HOTBAR_SWAP && action != InventoryAction.HOTBAR_MOVE_AND_READD) {
            return;
        }
        ItemStack item = event.getCurrentItem();
        if (item == null) {
            return;
        }
        Location location = inventory.getLocation();
        if (location == null) {
            return;
        }
        BrewingStandData standData = this.brewingStands.get(BukkitBlock.from(location.getBlock()));
        if (standData == null) {
            return;
        }
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        BrewingSlot brewingSlot = standData.getSlot(slot);
        if (!brewingSlot.isBrewed()) {
            return;
        }
        List<ItemStack> ingredients = brewingSlot.getIngredients();
        if (ingredients.isEmpty()) {
            return;
        }
        List<SkillSource<BrewingXpSource>> sources = this.getSources(ingredients);
        ConcurrentHashMap<Skill, Double> totalXpMap = new ConcurrentHashMap<Skill, Double>();
        brewingSlot.setBrewed(false);
        brewingSlot.resetIngredients();
        for (SkillSource<BrewingXpSource> skillSource : sources) {
            if (skillSource == null) {
                return;
            }
            BrewingXpSource source = skillSource.source();
            Skill skill = skillSource.skill();
            if (this.failsChecks((Cancellable)event, player, location, skill)) {
                return;
            }
            totalXpMap.put(skill, totalXpMap.getOrDefault(skill, 0.0) + source.getXp());
        }
        User user = this.plugin.getUser(player);
        for (Skill skill : totalXpMap.keySet()) {
            this.plugin.getLevelManager().addXp(user, skill, sources.get(0).source(), totalXpMap.getOrDefault(skill, 0.0));
        }
    }

    private void checkBrewedSlots(BrewEvent event) {
        BrewerInventory before = event.getContents();
        ItemStack ingredient = before.getIngredient();
        if (ingredient == null) {
            return;
        }
        ItemStack clonedIngredient = ingredient.clone();
        ItemStack[] beforeItems = Arrays.copyOf(before.getContents(), 3);
        this.plugin.getScheduler().scheduleAtLocation(event.getBlock().getLocation(), () -> {
            BlockState blockState = event.getBlock().getState();
            if (blockState instanceof BrewingStand) {
                BrewingStand brewingStand = (BrewingStand)blockState;
                BrewerInventory after = brewingStand.getInventory();
                ItemStack[] afterItems = Arrays.copyOf(after.getContents(), 3);
                BlockPosition pos = BukkitBlock.from(event.getBlock());
                BrewingStandData standData = this.getBrewingStandData(clonedIngredient, beforeItems, afterItems, pos);
                this.brewingStands.put(pos, standData);
            }
        }, 50L, TimeUnit.MILLISECONDS);
    }

    @NotNull
    private BrewingStandData getBrewingStandData(ItemStack ingredient, ItemStack[] beforeItems, ItemStack[] afterItems, BlockPosition pos) {
        BrewingStandData standData = this.brewingStands.getOrDefault(pos, new BrewingStandData());
        for (int i = 0; i < 3; ++i) {
            ItemStack beforeItem = beforeItems[i];
            ItemStack afterItem = afterItems[i];
            if (beforeItem == null || beforeItem.getType() == Material.AIR || afterItem == null || afterItem.getType() == Material.AIR || beforeItem.equals((Object)afterItem)) continue;
            BrewingSlot slot = standData.getSlot(i);
            slot.setBrewed(true);
            if (slot.getIngredients().size() >= 5) continue;
            slot.addIngredient(ingredient);
        }
        return standData;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBrewingStandPlace(BlockPlaceEvent event) {
        if (this.disabled()) {
            return;
        }
        Block block = event.getBlock();
        if (block.getType() != Material.BREWING_STAND) {
            return;
        }
        block.setMetadata("skillsBrewingStandOwner", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)event.getPlayer().getUniqueId()));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBrewingStandBreak(BlockBreakEvent event) {
        if (this.disabled()) {
            return;
        }
        Block block = event.getBlock();
        if (block.getType().equals((Object)Material.BREWING_STAND)) {
            return;
        }
        if (event.getBlock().hasMetadata("skillsBrewingStandOwner")) {
            event.getBlock().removeMetadata("skillsBrewingStandOwner", (Plugin)this.plugin);
        }
        this.brewingStands.remove(BukkitBlock.from(event.getBlock()));
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        if (this.disabled()) {
            return;
        }
        Inventory inventory = event.getInventory();
        if (!inventory.getType().equals((Object)InventoryType.BREWING)) {
            return;
        }
        if (inventory.getHolder() == null) {
            return;
        }
        if (inventory.getLocation() == null) {
            return;
        }
        Block block = inventory.getLocation().getBlock();
        if (!block.hasMetadata("skillsBrewingStandOwner")) {
            block.setMetadata("skillsBrewingStandOwner", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)event.getPlayer().getUniqueId()));
        }
    }

    @Nullable
    private SkillSource<BrewingXpSource> getSource(ItemStack item) {
        for (SkillSource<BrewingXpSource> entry : this.plugin.getSkillManager().getSourcesOfType(BrewingXpSource.class)) {
            if (!this.plugin.getItemRegistry().passesFilter(item, entry.source().getIngredients())) continue;
            return entry;
        }
        return null;
    }

    private List<SkillSource<BrewingXpSource>> getSources(List<ItemStack> items) {
        return items.stream().map(this::getSource).collect(Collectors.toList());
    }

    public static class BrewingStandData {
        private final Map<Integer, BrewingSlot> slots = new ConcurrentHashMap<Integer, BrewingSlot>();

        public BrewingSlot getSlot(int slot) {
            return this.slots.computeIfAbsent(slot, s -> new BrewingSlot());
        }
    }

    public static class BrewingSlot {
        private boolean brewed = false;
        private final List<ItemStack> ingredients = new ArrayList<ItemStack>();

        public boolean isBrewed() {
            return this.brewed;
        }

        public void setBrewed(boolean brewed) {
            this.brewed = brewed;
        }

        public List<ItemStack> getIngredients() {
            return this.ingredients;
        }

        public void addIngredient(ItemStack item) {
            this.ingredients.add(item);
        }

        public void resetIngredients() {
            this.ingredients.clear();
        }
    }
}

