/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.skills.mining;

import dev.aurelium.auraskills.api.ability.Abilities;
import dev.aurelium.auraskills.api.damage.DamageMeta;
import dev.aurelium.auraskills.api.damage.DamageModifier;
import dev.aurelium.auraskills.api.damage.DamageType;
import dev.aurelium.auraskills.api.event.damage.DamageEvent;
import dev.aurelium.auraskills.api.event.item.ItemDisableEvent;
import dev.aurelium.auraskills.api.event.item.ItemEnableEvent;
import dev.aurelium.auraskills.api.event.item.ItemToggleEvent;
import dev.aurelium.auraskills.api.item.ModifierType;
import dev.aurelium.auraskills.api.stat.StatModifier;
import dev.aurelium.auraskills.api.stat.Stats;
import dev.aurelium.auraskills.api.util.AuraSkillsModifier;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.ability.BukkitAbilityImpl;
import dev.aurelium.auraskills.bukkit.user.BukkitUser;
import dev.aurelium.auraskills.bukkit.util.ItemUtils;
import dev.aurelium.auraskills.bukkit.util.VersionUtils;
import dev.aurelium.auraskills.common.user.User;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerItemDamageEvent;

public class MiningAbilities
extends BukkitAbilityImpl {
    public MiningAbilities(AuraSkills plugin) {
        super(plugin, Abilities.LUCKY_MINER, Abilities.MINER, Abilities.PICK_MASTER, Abilities.HARDENED_ARMOR, Abilities.STAMINA);
    }

    public boolean dropsMineralDirectly(Block block) {
        Material mat = block.getType();
        switch (mat) {
            case DIAMOND_ORE: 
            case REDSTONE_ORE: 
            case EMERALD_ORE: 
            case COAL_ORE: 
            case LAPIS_ORE: 
            case NETHER_QUARTZ_ORE: 
            case NETHER_GOLD_ORE: {
                return true;
            }
        }
        if (VersionUtils.isAtLeastVersion(17)) {
            switch (mat) {
                case IRON_ORE: 
                case DEEPSLATE_IRON_ORE: 
                case GOLD_ORE: 
                case DEEPSLATE_GOLD_ORE: 
                case COPPER_ORE: 
                case DEEPSLATE_COPPER_ORE: 
                case DEEPSLATE_DIAMOND_ORE: 
                case DEEPSLATE_REDSTONE_ORE: 
                case DEEPSLATE_EMERALD_ORE: 
                case DEEPSLATE_COAL_ORE: 
                case DEEPSLATE_LAPIS_ORE: {
                    return true;
                }
            }
        }
        return false;
    }

    private DamageModifier pickMaster(Player player, User user) {
        Abilities ability = Abilities.PICK_MASTER;
        if (this.isDisabled(ability) || this.failsChecks(player, ability)) {
            return DamageModifier.none();
        }
        if (user.getAbilityLevel(ability) <= 0) {
            return DamageModifier.none();
        }
        return new DamageModifier(this.getValue(ability, user) / 100.0, DamageModifier.Operation.ADD_COMBINED);
    }

    @EventHandler(ignoreCancelled=true)
    public void damageListener(DamageEvent event) {
        DamageMeta meta = event.getDamageMeta();
        Player attacker = meta.getAttackerAsPlayer();
        if (attacker != null && meta.getDamageType() == DamageType.PICKAXE) {
            User user = this.plugin.getUser(attacker);
            meta.addAttackModifier(this.pickMaster(attacker, user));
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void hardenedArmor(PlayerItemDamageEvent event) {
        Abilities ability = Abilities.HARDENED_ARMOR;
        if (this.isDisabled(ability)) {
            return;
        }
        Player player = event.getPlayer();
        if (!ItemUtils.isArmor(event.getItem().getType())) {
            return;
        }
        User user = this.plugin.getUser(player);
        if (this.failsChecks(player, ability)) {
            return;
        }
        if (this.rand.nextDouble() < this.getValue(ability, user) / 100.0) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void applyStamina(ItemEnableEvent event) {
        if (this.isNotStamina(event)) {
            return;
        }
        Player player = event.getPlayer();
        BukkitUser user = BukkitUser.getUser(event.getUser());
        Abilities ability = Abilities.STAMINA;
        if (this.isDisabled(ability)) {
            return;
        }
        if (this.failsChecks(player, ability)) {
            return;
        }
        if (user.getAbilityLevel(ability) == 0) {
            return;
        }
        user.addStatModifier(new StatModifier("mining-stamina", Stats.TOUGHNESS, (double)((int)this.getValue(ability, user)), AuraSkillsModifier.Operation.ADD));
    }

    @EventHandler
    public void removeStamina(ItemDisableEvent event) {
        if (this.isNotStamina(event)) {
            return;
        }
        BukkitUser user = BukkitUser.getUser(event.getUser());
        user.removeStatModifier("mining-stamina");
    }

    private boolean isNotStamina(ItemToggleEvent event) {
        if (!ItemUtils.isPickaxe(event.getItem().getType())) {
            return true;
        }
        return event.getType() != ModifierType.ITEM;
    }
}

