/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.skills.foraging;

import com.sk89q.worldedit.WorldEdit;
import dev.aurelium.auraskills.api.event.mana.ManaAbilityBlockBreakEvent;
import dev.aurelium.auraskills.api.mana.ManaAbilities;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.source.SkillSource;
import dev.aurelium.auraskills.api.source.XpSource;
import dev.aurelium.auraskills.api.source.type.BlockXpSource;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.mana.ReadiedManaAbility;
import dev.aurelium.auraskills.bukkit.source.BlockLeveler;
import dev.aurelium.auraskills.bukkit.util.BlockFaceUtil;
import dev.aurelium.auraskills.common.message.type.ManaAbilityMessage;
import dev.aurelium.auraskills.common.source.SourceTag;
import dev.aurelium.auraskills.common.user.User;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class Treecapitator
extends ReadiedManaAbility {
    private final boolean giveXp = ManaAbilities.TREECAPITATOR.optionBoolean("give_xp", true);

    public Treecapitator(AuraSkills plugin) {
        super(plugin, ManaAbilities.TREECAPITATOR, ManaAbilityMessage.TREECAPITATOR_START, ManaAbilityMessage.TREECAPITATOR_END, new String[]{"_AXE"}, new Action[]{Action.RIGHT_CLICK_AIR, Action.RIGHT_CLICK_BLOCK});
    }

    @Override
    public void onActivate(Player player, User user) {
        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
    }

    @Override
    public void onStop(Player player, User user) {
    }

    @Override
    protected boolean materialMatches(String checked, Player player) {
        Material checkMaterial;
        String wandItem;
        String wandString;
        Material wandMaterial;
        if (this.plugin.getServer().getPluginManager().isPluginEnabled("WorldEdit") && player.hasPermission("worldedit.wand") && (wandMaterial = Material.matchMaterial((String)(wandString = (wandItem = WorldEdit.getInstance().getConfiguration().wandItem).contains(":") ? wandItem.split(":")[1] : wandItem).toUpperCase(Locale.ROOT))) == (checkMaterial = Material.matchMaterial((String)checked.toUpperCase(Locale.ROOT)))) {
            return false;
        }
        for (String material : this.getMaterials()) {
            if (!checked.contains(material)) continue;
            return true;
        }
        return false;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBreak(BlockBreakEvent event) {
        if (this.isDisabled()) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getBlock();
        if (this.plugin.getRegionManager().isPlacedBlock(block)) {
            return;
        }
        if (this.manaAbility.optionBoolean("call_block_break_event", false) && block.hasMetadata("AureliumSkills-Treecapitator") && event.getClass() != BlockBreakEvent.class) {
            return;
        }
        BlockXpSource source = this.getNonStrippedSource(block);
        if (source == null) {
            return;
        }
        if (this.plugin.getSkillManager().hasTag(source, SourceTag.TRUNKS)) {
            Player player = event.getPlayer();
            if (this.failsChecks(player)) {
                return;
            }
            User user = this.plugin.getUser(player);
            if (this.isActivated(user)) {
                this.breakTree(player, user, block, source);
                return;
            }
            if (this.isHoldingMaterial(player) && this.checkActivation(player)) {
                this.breakTree(player, user, block, source);
            }
        }
    }

    public void breakTree(Player player, User user, Block block, BlockXpSource source) {
        AtomicInteger taskCount = new AtomicInteger(1);
        TreecapitatorTree tree = new TreecapitatorTree(block, source);
        double multiplier = this.manaAbility.optionDouble("durability_multiplier", 0.0);
        if (this.manaAbility.optionBoolean("max_limit_durability", false)) {
            tree.setMaxBlocks(this.getHoldingMaterialDurability(player, tree.getMaxBlocks()));
        }
        this.breakBlock(player, user, block, tree, taskCount, () -> {
            taskCount.decrementAndGet();
            if (taskCount.get() == 0) {
                this.setHoldingMaterialDurability(player, tree.getBlocksBroken(), multiplier);
            }
        });
    }

    private void breakBlock(Player player, User user, Block block, TreecapitatorTree tree, AtomicInteger taskCount, Runnable onComplete) {
        if (tree.getBlocksBroken() > tree.getMaxBlocks()) {
            onComplete.run();
            return;
        }
        for (Block adjacentBlock : BlockFaceUtil.getSurroundingBlocks(block)) {
            BlockXpSource adjSource = this.getSource(adjacentBlock);
            if (!this.plugin.getSkillManager().hasTag(adjSource, SourceTag.TREECAPITATOR_APPLICABLE) || this.plugin.getRegionManager().isPlacedBlock(adjacentBlock)) continue;
            if (this.manaAbility.optionBoolean("call_block_break_event", false)) {
                adjacentBlock.setMetadata("AureliumSkills-Treecapitator", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
                ManaAbilityBlockBreakEvent event = new ManaAbilityBlockBreakEvent(adjacentBlock, player);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    adjacentBlock.breakNaturally(player.getInventory().getItemInMainHand());
                }
                adjacentBlock.removeMetadata("AureliumSkills-Treecapitator", (Plugin)this.plugin);
            } else {
                adjacentBlock.breakNaturally();
            }
            tree.incrementBlocksBroken();
            if (adjSource != null && this.giveXp) {
                this.plugin.getLevelManager().addXp(user, this.manaAbility.getSkill(), adjSource, adjSource.getXp());
            }
            Block originalBlock = tree.getOriginalBlock();
            if (adjacentBlock.getX() > originalBlock.getX() + 6 || adjacentBlock.getZ() > originalBlock.getZ() + 6 || adjacentBlock.getY() > originalBlock.getY() + 31) {
                onComplete.run();
                return;
            }
            taskCount.incrementAndGet();
            this.plugin.getScheduler().scheduleAtLocation(adjacentBlock.getLocation(), () -> this.breakBlock(player, user, adjacentBlock, tree, taskCount, onComplete), 50L, TimeUnit.MILLISECONDS);
        }
        onComplete.run();
    }

    @Nullable
    private BlockXpSource getNonStrippedSource(Block block) {
        String target = block.getType().toString();
        if (target.contains("STRIPPED")) {
            XpSource newSource;
            String blockOrigin = target.replace("STRIPPED_", "");
            Material newTarget = Material.matchMaterial((String)blockOrigin);
            if (newTarget != null && newTarget.isBlock() && (newSource = this.plugin.getSkillManager().getSourceById(NamespacedId.fromDefault(newTarget.toString().toLowerCase(Locale.ROOT)))) instanceof BlockXpSource) {
                BlockXpSource blockXpSource = (BlockXpSource)newSource;
                return blockXpSource;
            }
        } else {
            return this.getSource(block);
        }
        return null;
    }

    @Nullable
    private BlockXpSource getSource(Block block) {
        SkillSource<BlockXpSource> skillSource = this.plugin.getLevelManager().getLeveler(BlockLeveler.class).getSource(block, BlockXpSource.BlockTriggers.BREAK);
        if (skillSource != null) {
            return skillSource.source();
        }
        return null;
    }

    private static class TreecapitatorTree {
        private final Block originalBlock;
        private int blocksBroken;
        private int maxBlocks;

        public TreecapitatorTree(Block originalBlock, BlockXpSource source) {
            this.originalBlock = originalBlock;
            this.setMaxBlocks(source);
        }

        public Block getOriginalBlock() {
            return this.originalBlock;
        }

        public int getBlocksBroken() {
            return this.blocksBroken;
        }

        public void incrementBlocksBroken() {
            ++this.blocksBroken;
        }

        public int getMaxBlocks() {
            return this.maxBlocks;
        }

        public void setMaxBlocks(int maxBlocks) {
            this.maxBlocks = maxBlocks;
        }

        private void setMaxBlocks(BlockXpSource source) {
            int maxBlocks = source != null && source.getMaxBlocks() >= 1 ? source.getMaxBlocks() : 100;
            double multiplier = ManaAbilities.TREECAPITATOR.optionDouble("max_blocks_multiplier", 1.0);
            this.maxBlocks = (int)((double)maxBlocks * multiplier);
        }
    }
}

