/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.skills.archery;

import dev.aurelium.auraskills.api.ability.Abilities;
import dev.aurelium.auraskills.api.ability.Ability;
import dev.aurelium.auraskills.api.damage.DamageMeta;
import dev.aurelium.auraskills.api.damage.DamageModifier;
import dev.aurelium.auraskills.api.damage.DamageType;
import dev.aurelium.auraskills.api.event.damage.DamageEvent;
import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.ability.BukkitAbilityImpl;
import dev.aurelium.auraskills.bukkit.util.AttributeCompat;
import dev.aurelium.auraskills.bukkit.util.CompatUtil;
import dev.aurelium.auraskills.bukkit.util.VersionUtils;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.Trident;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;

public class ArcheryAbilities
extends BukkitAbilityImpl {
    private final UUID legacyStunId = UUID.fromString("886ccad1-20f0-48e4-8634-53f3a76cf2ea");
    private final String legacyStunName = "AureliumSkills-Stun";
    private final String stunKey = "stun_ability";

    public ArcheryAbilities(AuraSkills plugin) {
        super(plugin, Abilities.RETRIEVAL, Abilities.ARCHER, Abilities.BOW_MASTER, Abilities.PIERCING, Abilities.STUN);
    }

    private DamageModifier bowMaster(Player player, User user) {
        Abilities ability = Abilities.BOW_MASTER;
        if (this.isDisabled(ability) || this.failsChecks(player, ability)) {
            return DamageModifier.none();
        }
        if (user.getAbilityLevel(ability) <= 0) {
            return DamageModifier.none();
        }
        return new DamageModifier(this.getValue(ability, user) / 100.0, DamageModifier.Operation.ADD_COMBINED);
    }

    @EventHandler(ignoreCancelled=true)
    public void damageListener(DamageEvent event) {
        DamageMeta meta = event.getDamageMeta();
        Player attacker = meta.getAttackerAsPlayer();
        if (attacker != null) {
            User user = this.plugin.getUser(attacker);
            if (meta.getDamageType() == DamageType.BOW) {
                meta.addAttackModifier(this.bowMaster(attacker, user));
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void archeryListener(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (!(entity instanceof Arrow)) {
            return;
        }
        Arrow arrow = (Arrow)entity;
        ProjectileSource projectileSource = arrow.getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player player = (Player)projectileSource;
        if (player.hasMetadata("NPC")) {
            return;
        }
        User user = this.plugin.getUser(player);
        Entity entity2 = event.getEntity();
        if (entity2 instanceof LivingEntity) {
            LivingEntity entity3 = (LivingEntity)entity2;
            this.stun(player, user, entity3);
        }
        this.piercing(player, event, user, arrow);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void pierceListener(EntityShootBowEvent event) {
        Entity entity = event.getProjectile();
        if (!(entity instanceof Arrow)) {
            return;
        }
        Arrow arrow = (Arrow)entity;
        ProjectileSource projectileSource = arrow.getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player player = (Player)projectileSource;
        User user = this.plugin.getUser(player);
        this.pierceInit(user, player, arrow);
    }

    public void stun(Player player, User user, LivingEntity entity) {
        Abilities ability = Abilities.STUN;
        double stunSpeedReduction = ability.optionDouble("speed_reduction", 0.2);
        if (this.failsChecks(player, ability)) {
            return;
        }
        if (this.rand.nextDouble() < this.getValue(ability, user) / 100.0) {
            AttributeInstance speed = entity.getAttribute(AttributeCompat.movementSpeed);
            if (speed == null) {
                return;
            }
            for (AttributeModifier existingModifier : speed.getModifiers()) {
                if (!this.isStunModifier(existingModifier)) continue;
                return;
            }
            AttributeModifier modifier = this.getAttributeModifier(speed, stunSpeedReduction);
            speed.addModifier(modifier);
            this.scheduleStunRemoval(entity);
        }
    }

    @NotNull
    private AttributeModifier getAttributeModifier(AttributeInstance speed, double stunSpeedReduction) {
        AttributeModifier modifier;
        double reducedSpeed = speed.getValue() * stunSpeedReduction;
        double attributeValue = -1.0 * reducedSpeed;
        if (VersionUtils.isAtLeastVersion(21)) {
            NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "stun_ability");
            modifier = new AttributeModifier(key, attributeValue, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.ANY);
        } else {
            modifier = new AttributeModifier(this.legacyStunId, "AureliumSkills-Stun", attributeValue, AttributeModifier.Operation.ADD_NUMBER);
        }
        return modifier;
    }

    private void scheduleStunRemoval(LivingEntity entity) {
        this.plugin.getScheduler().scheduleAtEntity((Entity)entity, () -> {
            AttributeInstance newSpeed = entity.getAttribute(AttributeCompat.movementSpeed);
            if (newSpeed == null) {
                return;
            }
            for (AttributeModifier attributeModifier : newSpeed.getModifiers()) {
                if (!this.isStunModifier(attributeModifier)) continue;
                newSpeed.removeModifier(attributeModifier);
            }
        }, 2000L, TimeUnit.MILLISECONDS);
    }

    @EventHandler
    public void removeStun(PlayerQuitEvent event) {
        AttributeInstance speed = event.getPlayer().getAttribute(AttributeCompat.movementSpeed);
        if (speed == null) {
            return;
        }
        for (AttributeModifier attributeModifier : speed.getModifiers()) {
            if (!this.isStunModifier(attributeModifier)) continue;
            speed.removeModifier(attributeModifier);
        }
    }

    private boolean isStunModifier(AttributeModifier modifier) {
        if (modifier.getName().equals("AureliumSkills-Stun")) {
            return true;
        }
        if (VersionUtils.isAtLeastVersion(21)) {
            String pluginNamespace = "auraskills";
            String namespace = modifier.getKey().getNamespace();
            String key = modifier.getKey().getKey();
            return namespace.equals("auraskills") && key.equals("stun_ability");
        }
        return false;
    }

    public void piercing(Player player, EntityDamageByEntityEvent event, User user, Arrow arrow) {
        Player damagedPlayer;
        Abilities ability = Abilities.PIERCING;
        if (this.isDisabled(ability)) {
            return;
        }
        if (this.failsChecks(player, ability)) {
            return;
        }
        Entity damaged = event.getEntity();
        if (damaged instanceof Player && (damagedPlayer = (Player)damaged).isBlocking()) {
            return;
        }
        if (this.rand.nextDouble() < this.getValue(ability, user) / 100.0 && arrow.getPierceLevel() < 127) {
            arrow.setPierceLevel(arrow.getPierceLevel() + 1);
        }
    }

    public void pierceInit(User user, Player player, Arrow arrow) {
        Abilities ability = Abilities.PIERCING;
        if (this.isDisabled(ability)) {
            return;
        }
        if (this.failsChecks(player, ability)) {
            return;
        }
        if (this.rand.nextDouble() < this.getValue(ability, user) / 100.0 && arrow.getPierceLevel() < 127) {
            arrow.setPierceLevel(arrow.getPierceLevel() + 1);
        }
    }

    @Override
    public String replaceDescPlaceholders(String input, Ability ability, User user) {
        if (ability.equals(Abilities.RETRIEVAL)) {
            return TextUtil.replace(input, "{time}", NumberUtil.format1(ability.optionDouble("delay_sec", 3.0)));
        }
        if (ability.equals(Abilities.STUN)) {
            return TextUtil.replace(input, "{reduction_percent}", NumberUtil.format1(ability.optionDouble("speed_reduction", 0.2) * 100.0));
        }
        return input;
    }

    @EventHandler
    public void retrieval(ProjectileHitEvent event) {
        if (event.getHitBlock() == null || event.getHitEntity() != null) {
            return;
        }
        Projectile projectile = event.getEntity();
        if (!(projectile instanceof AbstractArrow)) {
            return;
        }
        AbstractArrow arrow = (AbstractArrow)projectile;
        if (event.getEntity() instanceof Trident) {
            return;
        }
        if (arrow.getPickupStatus() != AbstractArrow.PickupStatus.ALLOWED) {
            return;
        }
        ProjectileSource projectileSource = arrow.getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player player = (Player)projectileSource;
        Abilities ability = Abilities.RETRIEVAL;
        if (this.isDisabled(ability)) {
            return;
        }
        if (this.failsChecks(player, ability)) {
            return;
        }
        ItemStack item = this.getArrowItem(arrow);
        this.plugin.getScheduler().scheduleAtEntity((Entity)arrow, () -> {
            if (!arrow.isValid()) {
                return;
            }
            if (!arrow.getWorld().equals((Object)player.getWorld())) {
                return;
            }
            double value = this.getValue(ability, this.plugin.getUser(player));
            if (arrow.getLocation().distanceSquared(player.getLocation()) > value * value) {
                return;
            }
            item.setAmount(1);
            this.plugin.getScheduler().executeAtEntity((Entity)player, task -> {
                if (!player.getInventory().addItem(new ItemStack[]{item}).isEmpty()) {
                    return;
                }
                this.plugin.getScheduler().executeAtEntity((Entity)arrow, t2 -> {
                    arrow.getWorld().spawnParticle(CompatUtil.witchParticle(), arrow.getLocation(), 5, 0.0, 0.0, 0.0);
                    player.playSound(player.getLocation(), Sound.ENTITY_ITEM_PICKUP, 0.4f, 1.9f);
                    arrow.remove();
                });
            });
        }, Math.round(ability.optionDouble("delay_sec", 3.0) * 1000.0), TimeUnit.MILLISECONDS);
    }

    private ItemStack getArrowItem(AbstractArrow abstractArrow) {
        if (abstractArrow instanceof Arrow) {
            Arrow arrow = (Arrow)abstractArrow;
            if (this.isNormalArrow(arrow)) {
                return new ItemStack(Material.ARROW);
            }
            ItemStack item = new ItemStack(Material.TIPPED_ARROW);
            PotionMeta meta = (PotionMeta)item.getItemMeta();
            if (meta != null) {
                if (VersionUtils.isAtLeastVersion(20, 2)) {
                    meta.setBasePotionType(arrow.getBasePotionType());
                } else {
                    this.setLegacyTippedArrow(arrow, meta);
                }
                item.setItemMeta((ItemMeta)meta);
            }
            return item;
        }
        if (abstractArrow instanceof SpectralArrow) {
            return new ItemStack(Material.SPECTRAL_ARROW);
        }
        return new ItemStack(Material.ARROW);
    }

    private boolean isNormalArrow(Arrow arrow) {
        if (VersionUtils.isAtLeastVersion(20, 2)) {
            return arrow.getBasePotionType() == null || arrow.getBasePotionType().toString().equals("UNCRAFTABLE");
        }
        try {
            Method getBasePotionData = arrow.getClass().getDeclaredMethod("getBasePotionData", new Class[0]);
            Object potionData = getBasePotionData.invoke((Object)arrow, new Object[0]);
            Method getType = potionData.getClass().getDeclaredMethod("getType", new Class[0]);
            Object potionType = getType.invoke(potionData, new Object[0]);
            return potionType.toString().equals("UNCRAFTABLE");
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private void setLegacyTippedArrow(Arrow arrow, PotionMeta meta) {
        try {
            Method getBasePotionData = arrow.getClass().getDeclaredMethod("getBasePotionData", new Class[0]);
            Object potionData = getBasePotionData.invoke((Object)arrow, new Object[0]);
            Class<?> potionDataClass = Class.forName("org.bukkit.potion.PotionData");
            Method setBasePotionData = PotionMeta.class.getDeclaredMethod("setBasePotionData", potionDataClass);
            setBasePotionData.invoke((Object)meta, potionData);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

