/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.requirement;

import com.google.common.collect.Sets;
import dev.aurelium.auraskills.api.item.ModifierType;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.requirement.BiomeNode;
import dev.aurelium.auraskills.bukkit.requirement.BlockRequirement;
import dev.aurelium.auraskills.bukkit.requirement.BukkitLootRequirements;
import dev.aurelium.auraskills.bukkit.requirement.EnchantmentNode;
import dev.aurelium.auraskills.bukkit.requirement.ExcludedWorldNode;
import dev.aurelium.auraskills.bukkit.requirement.GlobalRequirement;
import dev.aurelium.auraskills.bukkit.requirement.ItemNode;
import dev.aurelium.auraskills.bukkit.requirement.PermissionNode;
import dev.aurelium.auraskills.bukkit.requirement.RegionNode;
import dev.aurelium.auraskills.bukkit.requirement.RequirementNode;
import dev.aurelium.auraskills.bukkit.requirement.SkillNode;
import dev.aurelium.auraskills.bukkit.requirement.StatNode;
import dev.aurelium.auraskills.bukkit.requirement.WorldNode;
import dev.aurelium.auraskills.common.config.ConfigurateLoader;
import dev.aurelium.auraskills.common.scheduler.TaskRunnable;
import dev.aurelium.auraskills.configurate.ConfigurationNode;
import dev.aurelium.auraskills.configurate.serialize.TypeSerializerCollection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;

public class RequirementManager
implements Listener {
    private Set<GlobalRequirement> globalRequirements;
    private List<BlockRequirement> blockRequirements;
    private final Map<UUID, Integer> errorMessageTimer = new ConcurrentHashMap<UUID, Integer>();
    private final AuraSkills plugin;

    public RequirementManager(AuraSkills plugin) {
        this.plugin = plugin;
        this.load();
        this.loadBlocks();
        this.tickTimer();
    }

    public void load() {
        ConfigurateLoader loader = new ConfigurateLoader(this.plugin, TypeSerializerCollection.builder().build());
        try {
            ConfigurationNode config = loader.loadUserFile("config.yml");
            this.globalRequirements = Sets.newConcurrentHashSet();
            int loaded = 0;
            for (ModifierType type : ModifierType.values()) {
                List<String> list = config.node("requirement", type.name().toLowerCase(Locale.ROOT), "global").getList(String.class, new ArrayList());
                for (String text : list) {
                    String[] splitText = text.split(" ");
                    try {
                        Material material = Material.valueOf((String)splitText[0].toUpperCase(Locale.ROOT));
                        HashMap<Skill, Integer> requirements = new HashMap<Skill, Integer>();
                        for (int i = 1; i < splitText.length; ++i) {
                            String requirementText = splitText[i];
                            try {
                                Skill skill = (Skill)this.plugin.getSkillRegistry().getOrNull(NamespacedId.fromDefault(requirementText.split(":")[0].toLowerCase(Locale.ROOT)));
                                if (skill == null) continue;
                                int level = Integer.parseInt(requirementText.split(":")[1]);
                                requirements.put(skill, level);
                                continue;
                            }
                            catch (Exception e) {
                                this.plugin.logger().warn("Error parsing global skill " + type.name().toLowerCase(Locale.ROOT) + " requirement skill level pair with text " + requirementText);
                            }
                        }
                        GlobalRequirement globalRequirement = new GlobalRequirement(type, material, Map.copyOf(requirements));
                        this.globalRequirements.add(globalRequirement);
                        ++loaded;
                    }
                    catch (IllegalArgumentException e) {
                        this.plugin.logger().warn("Error loading global requirement with text " + text + ", is your material valid?");
                        e.printStackTrace();
                    }
                }
            }
            if (loaded > 0) {
                this.plugin.logger().info("Loaded " + loaded + " global requirement" + (loaded != 1 ? "s" : ""));
            }
        }
        catch (IOException e) {
            this.plugin.logger().warn("Error loading global requirements: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public BukkitLootRequirements getLootRequirements(ConfigurationNode config) {
        return new BukkitLootRequirements(this.parseTypes(config.node("requirements").childrenList()));
    }

    public void loadBlocks() {
        ConfigurateLoader loader = new ConfigurateLoader(this.plugin, TypeSerializerCollection.builder().build());
        try {
            ConfigurationNode config = loader.loadUserFile("config.yml");
            this.blockRequirements = new ArrayList<BlockRequirement>();
            List<? extends ConfigurationNode> blockNodes = config.node("requirement", "blocks", "list").childrenList();
            for (ConfigurationNode configurationNode : blockNodes) {
                Material material = Material.valueOf((String)configurationNode.node("material").getString("").toUpperCase(Locale.ROOT));
                boolean allowPlace = configurationNode.node("allow_place").getBoolean(false);
                boolean allowBreak = configurationNode.node("allow_break").getBoolean(false);
                boolean allowHarvest = configurationNode.node("allow_harvest").getBoolean(false);
                List<RequirementNode> nodes = this.parseTypes(configurationNode.node("requirements").childrenList());
                BlockRequirement blockRequirement = new BlockRequirement(material, allowPlace, allowBreak, allowHarvest, nodes);
                this.blockRequirements.add(blockRequirement);
            }
            if (!this.blockRequirements.isEmpty()) {
                this.plugin.logger().info("Loaded " + this.blockRequirements.size() + " block requirement" + (this.blockRequirements.size() != 1 ? "s" : ""));
            }
        }
        catch (IOException e) {
            this.plugin.logger().warn("Error loading block requirements: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private List<RequirementNode> parseTypes(List<? extends ConfigurationNode> requirementNodes) {
        ArrayList<RequirementNode> nodes = new ArrayList<RequirementNode>();
        try {
            block24: for (ConfigurationNode configurationNode : requirementNodes) {
                String type = configurationNode.node("type").getString("");
                String message = configurationNode.node("message").getString("");
                switch (type) {
                    case "skill_level": {
                        Skill skill = (Skill)this.plugin.getSkillRegistry().getOrNull(NamespacedId.fromDefault(configurationNode.node("skill").getString("").toLowerCase(Locale.ROOT)));
                        int level = configurationNode.node("level").getInt();
                        nodes.add(new SkillNode(this.plugin, skill, level, message));
                        continue block24;
                    }
                    case "permission": {
                        String permission = configurationNode.node("permission").getString();
                        nodes.add(new PermissionNode(this.plugin, permission, message));
                        continue block24;
                    }
                    case "excluded_world": {
                        String[] worlds = configurationNode.node("worlds").getList(String.class, new ArrayList()).toArray(new String[0]);
                        nodes.add(new ExcludedWorldNode(this.plugin, worlds, message));
                        continue block24;
                    }
                    case "stat": {
                        Stat stat = this.plugin.getStatManager().getEnabledStats().stream().filter(s -> s.getId().equals(NamespacedId.fromDefault(requirementNode.node("stat").getString("").toLowerCase(Locale.ROOT)))).findFirst().orElse(null);
                        int value = configurationNode.node("value").getInt();
                        nodes.add(new StatNode(this.plugin, stat, value, message));
                        continue block24;
                    }
                    case "world": {
                        String world = configurationNode.node("world").getString();
                        nodes.add(new WorldNode(this.plugin, world, message));
                        continue block24;
                    }
                    case "biome": {
                        String biome = configurationNode.node("biome").getString();
                        nodes.add(new BiomeNode(this.plugin, biome, message));
                        continue block24;
                    }
                    case "region": {
                        String region = configurationNode.node("region").getString();
                        nodes.add(new RegionNode(this.plugin, region, message));
                        continue block24;
                    }
                    case "item": {
                        String item = configurationNode.node("item").getString();
                        nodes.add(new ItemNode(this.plugin, item, message));
                        continue block24;
                    }
                    case "enchantment": {
                        String enchantment = configurationNode.node("enchantment").getString();
                        String level = configurationNode.node("level").getString();
                        String[] levelStrings = level != null ? level.split("-") : new String[]{};
                        int[] levels = Arrays.stream(levelStrings).mapToInt(s -> {
                            try {
                                return Integer.parseInt(s.trim());
                            }
                            catch (NumberFormatException e) {
                                return -1;
                            }
                        }).toArray();
                        int levelMin = levels.length >= 1 ? levels[0] : -1;
                        int levelMax = levels.length >= 2 ? levels[1] : levelMin;
                        nodes.add(new EnchantmentNode(this.plugin, enchantment, levelMin, levelMax, message));
                        continue block24;
                    }
                }
                this.plugin.logger().warn("Unknown requirement type: " + type);
            }
        }
        catch (IOException e) {
            this.plugin.logger().warn("Error loading requirements: " + e.getMessage());
            e.printStackTrace();
        }
        return nodes;
    }

    public Set<GlobalRequirement> getGlobalRequirements() {
        return this.globalRequirements;
    }

    public List<BlockRequirement> getBlocks() {
        return this.blockRequirements;
    }

    public Set<GlobalRequirement> getGlobalRequirementsType(ModifierType type) {
        Set matched = Sets.newConcurrentHashSet();
        for (GlobalRequirement requirement : this.globalRequirements) {
            if (requirement.getType() != type) continue;
            matched.add(requirement);
        }
        return matched;
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.errorMessageTimer.remove(event.getPlayer().getUniqueId());
    }

    public void tickTimer() {
        TaskRunnable task = new TaskRunnable(){

            @Override
            public void run() {
                for (UUID id : RequirementManager.this.errorMessageTimer.keySet()) {
                    int timer = RequirementManager.this.errorMessageTimer.get(id);
                    if (timer == 0) continue;
                    RequirementManager.this.errorMessageTimer.put(id, RequirementManager.this.errorMessageTimer.get(id) - 1);
                }
            }
        };
        this.plugin.getScheduler().timerSync(task, 0L, 250L, TimeUnit.MILLISECONDS);
    }

    public Map<UUID, Integer> getErrorMessageTimer() {
        return this.errorMessageTimer;
    }
}

