/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.requirement;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.hooks.WorldGuardHook;
import dev.aurelium.auraskills.bukkit.requirement.RequirementNode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class RegionNode
extends RequirementNode {
    private final String region;

    public RegionNode(AuraSkills plugin, String region, String message) {
        super(plugin, message);
        this.region = region;
    }

    @Override
    public boolean check(Player player) {
        RegionContainer container;
        RegionManager regions;
        if (this.plugin.getHookManager().isRegistered(WorldGuardHook.class) && (regions = (container = WorldGuard.getInstance().getPlatform().getRegionContainer()).get(BukkitAdapter.adapt((World)player.getWorld()))) != null) {
            ApplicableRegionSet regionSet = regions.getApplicableRegions(BukkitAdapter.asBlockVector((Location)player.getLocation()));
            if (regionSet.isVirtual() || regionSet.getRegions().isEmpty()) {
                return false;
            }
            for (ProtectedRegion playerRegion : regionSet) {
                if (this.region.equalsIgnoreCase(playerRegion.getId())) continue;
                return false;
            }
        }
        return true;
    }
}

