/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.region;

import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.region.BukkitRegionManager;
import dev.aurelium.auraskills.common.region.Region;
import dev.aurelium.auraskills.common.region.RegionCoordinate;
import dev.aurelium.auraskills.common.scheduler.TaskRunnable;
import java.util.concurrent.TimeUnit;
import org.bukkit.Chunk;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;

public class RegionListener
implements Listener {
    private final AuraSkills plugin;
    private final BukkitRegionManager regionManager;

    public RegionListener(AuraSkills plugin) {
        this.plugin = plugin;
        this.regionManager = plugin.getRegionManager();
        this.startSaveTimer();
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        Chunk chunk = event.getChunk();
        int regionX = (int)Math.floor((double)chunk.getX() / 32.0);
        int regionZ = (int)Math.floor((double)chunk.getZ() / 32.0);
        RegionCoordinate regionCoordinate = new RegionCoordinate(event.getWorld().getName(), regionX, regionZ);
        Region region = this.regionManager.getRegion(regionCoordinate);
        if (region == null || region.shouldReload()) {
            this.plugin.getScheduler().executeAsync(() -> {
                Region obtainedRegion = this.regionManager.getRegion(regionCoordinate);
                if (obtainedRegion == null) {
                    obtainedRegion = new Region(event.getWorld().getName(), regionX, regionZ);
                    this.regionManager.setRegion(regionCoordinate, obtainedRegion);
                    this.regionManager.loadRegion(obtainedRegion);
                } else if (obtainedRegion.shouldReload()) {
                    this.regionManager.loadRegion(obtainedRegion);
                }
            });
        }
    }

    public void startSaveTimer() {
        this.plugin.getScheduler().timerAsync(new TaskRunnable(){

            @Override
            public void run() {
                RegionListener.this.regionManager.saveAllRegions(true, false);
            }
        }, 5L, 5L, TimeUnit.MINUTES);
    }
}

