/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.region;

import com.google.common.collect.Sets;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.common.config.ConfigurateLoader;
import dev.aurelium.auraskills.common.region.WorldManager;
import dev.aurelium.auraskills.configurate.ConfigurationNode;
import dev.aurelium.auraskills.configurate.serialize.TypeSerializerCollection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.World;

public class BukkitWorldManager
implements WorldManager {
    private Set<String> blockedWorlds;
    private Set<String> disabledWorlds;
    private Set<String> blockedCheckBlockReplaceWorlds;
    private final AuraSkills plugin;

    public BukkitWorldManager(AuraSkills plugin) {
        this.plugin = plugin;
    }

    public void loadWorlds() {
        ConfigurateLoader loader = new ConfigurateLoader(this.plugin, TypeSerializerCollection.builder().build());
        try {
            ConfigurationNode config = loader.loadUserFile("config.yml");
            int blockedWorldsLoaded = 0;
            this.blockedWorlds = Sets.newConcurrentHashSet();
            this.disabledWorlds = Sets.newConcurrentHashSet();
            this.blockedCheckBlockReplaceWorlds = Sets.newConcurrentHashSet();
            for (String blockedWorld : config.node("blocked_worlds").getList(String.class, new ArrayList())) {
                this.blockedWorlds.add(blockedWorld);
                ++blockedWorldsLoaded;
            }
            for (String blockedWorld : config.node("disabled_worlds").getList(String.class, new ArrayList())) {
                this.disabledWorlds.add(blockedWorld);
                ++blockedWorldsLoaded;
            }
            for (String blockedWorld : config.node("check_block_replace", "blocked_worlds").getList(String.class, new ArrayList())) {
                this.blockedCheckBlockReplaceWorlds.add(blockedWorld);
                ++blockedWorldsLoaded;
            }
            this.plugin.logger().info("Loaded " + blockedWorldsLoaded + " blocked/disabled world" + (blockedWorldsLoaded != 1 ? "s" : ""));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isInBlockedWorld(Location location) {
        if (location.getWorld() == null) {
            return false;
        }
        World world = location.getWorld();
        return this.disabledWorlds.contains(world.getName()) || this.blockedWorlds.contains(world.getName());
    }

    public boolean isInDisabledWorld(Location location) {
        if (location.getWorld() == null) {
            return false;
        }
        World world = location.getWorld();
        return this.disabledWorlds.contains(world.getName());
    }

    public boolean isCheckReplaceDisabled(Location location) {
        if (location.getWorld() == null) {
            return false;
        }
        World world = location.getWorld();
        return this.blockedCheckBlockReplaceWorlds.contains(world.getName());
    }

    @Override
    public boolean isBlockedWorld(String worldName) {
        return this.blockedWorlds.contains(worldName);
    }

    @Override
    public boolean isDisabledWorld(String worldName) {
        return this.disabledWorlds.contains(worldName);
    }
}

