/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.menus.util;

import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.common.message.MessageKey;
import dev.aurelium.auraskills.common.message.type.UnitMessage;
import dev.aurelium.auraskills.common.util.text.Replacer;
import dev.aurelium.auraskills.slate.menu.ActiveMenu;
import dev.aurelium.auraskills.slate.util.TextUtil;
import java.util.Locale;
import org.bukkit.entity.Player;

public class PlaceholderHelper {
    private final AuraSkills plugin;

    public PlaceholderHelper(AuraSkills plugin) {
        this.plugin = plugin;
    }

    public String replaceMenuMessage(String placeholder, Player player, ActiveMenu activeMenu, Replacer replacements) {
        return this.replaceMenuMessage(placeholder, placeholder, player, activeMenu, replacements);
    }

    public String replaceMenuMessage(String placeholder, String def, Player player, ActiveMenu activeMenu, Replacer replacer) {
        Locale locale = this.plugin.getUser(player).getLocale();
        if (placeholder.endsWith("_unit")) {
            for (UnitMessage unitMessage : UnitMessage.values()) {
                if (!placeholder.endsWith(unitMessage.toString().toLowerCase(Locale.ROOT) + "_unit")) continue;
                return this.plugin.getMessageProvider().getRaw(unitMessage, locale);
            }
        }
        if (!placeholder.startsWith("{") || !placeholder.endsWith("}")) {
            return def;
        }
        String stripped = dev.aurelium.auraskills.common.util.text.TextUtil.replace(placeholder, "{", "", "}", "");
        MessageKey key = MessageKey.of("menus." + activeMenu.getName().toLowerCase(Locale.ROOT) + "." + stripped);
        String message = this.plugin.getMessageProvider().getRaw(key, locale);
        MessageKey commonKey = MessageKey.of("menus.common." + stripped);
        if (message.equals(key.getPath())) {
            message = this.plugin.getMessageProvider().getRaw(commonKey, locale);
        }
        if (!(message = dev.aurelium.auraskills.common.util.text.TextUtil.replace(message, replacer)).equals(commonKey.getPath())) {
            return message;
        }
        return null;
    }

    public String replaceMenuMessages(String source, Player player, ActiveMenu activeMenu, Replacer replacer) {
        String[] placeholders = TextUtil.substringsBetween(source, "{", "}");
        if (placeholders == null) {
            return source;
        }
        for (String placeholder : placeholders) {
            String replaced = this.replaceMenuMessage(placeholder, null, player, activeMenu, replacer);
            if (replaced == null) continue;
            source = dev.aurelium.auraskills.common.util.text.TextUtil.replace(source, "{" + placeholder + "}", replaced);
        }
        return source;
    }
}

