/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.menus.shared;

import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.common.util.data.DataUtil;
import dev.aurelium.auraskills.slate.info.TemplateInfo;
import dev.aurelium.auraskills.slate.inv.content.SlotPos;
import dev.aurelium.auraskills.slate.menu.ActiveMenu;
import dev.aurelium.auraskills.slate.menu.LoadedMenu;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.inventory.ItemStack;

public class SkillLevelItem {
    private final AuraSkills plugin;
    private final List<Integer> track;

    public SkillLevelItem(AuraSkills plugin) {
        this.plugin = plugin;
        this.track = SkillLevelItem.getDefaultTrack();
    }

    public static List<Integer> getDefaultTrack() {
        ArrayList<Integer> track = new ArrayList<Integer>();
        track.add(9);
        track.add(18);
        track.add(27);
        track.add(36);
        track.add(37);
        track.add(38);
        track.add(29);
        track.add(20);
        track.add(11);
        track.add(12);
        track.add(13);
        track.add(22);
        track.add(31);
        track.add(40);
        track.add(41);
        track.add(42);
        track.add(33);
        track.add(24);
        track.add(15);
        track.add(16);
        track.add(17);
        track.add(26);
        track.add(35);
        track.add(44);
        return track;
    }

    public void loadTrack() {
        Object trackObj;
        LoadedMenu menu = this.plugin.getSlate().getLoadedMenu("level_progression");
        if (menu != null && (trackObj = menu.options().get("track")) != null) {
            this.track.clear();
            this.track.addAll(DataUtil.castIntegerList(trackObj));
        }
    }

    public SlotPos slotPos(TemplateInfo<Integer> info) {
        int page = info.menu().getCurrentPage();
        int index = info.value() - this.startLevel(info.menu()) - page * this.itemsPerPage(info.menu());
        if (index < this.track.size()) {
            int pos = this.track.get(index);
            return SlotPos.of(pos / 9, pos % 9);
        }
        return SlotPos.of(1, 1);
    }

    public ItemStack modify(TemplateInfo<Integer> info) {
        Skill skill = (Skill)info.menu().getProperty("skill");
        int level = info.value();
        if (level > skill.getMaxLevel()) {
            return null;
        }
        if (info.menu().getOption(Boolean.class, "use_level_as_amount", true).booleanValue()) {
            if (level <= 64) {
                info.item().setAmount(level);
            } else {
                int overAmount = info.menu().getOption(Integer.class, "overMaxStackAmount", 1);
                info.item().setAmount(overAmount);
            }
        }
        return info.item();
    }

    public int itemsPerPage(ActiveMenu activeMenu) {
        return activeMenu.getOption(Integer.class, "items_per_page", 24);
    }

    public int startLevel(ActiveMenu activeMenu) {
        return activeMenu.getOption(Integer.class, "start_level", 1);
    }
}

