/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.menus;

import dev.aurelium.auraskills.api.bukkit.BukkitTraitHandler;
import dev.aurelium.auraskills.api.registry.NamespaceIdentified;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.util.AuraSkillsModifier;
import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.menus.shared.GlobalItems;
import dev.aurelium.auraskills.bukkit.menus.shared.ModifierInstance;
import dev.aurelium.auraskills.bukkit.menus.shared.ModifierInstances;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.data.DataUtil;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import dev.aurelium.auraskills.slate.builder.ItemBuilder;
import dev.aurelium.auraskills.slate.builder.MenuBuilder;
import dev.aurelium.auraskills.slate.info.PlaceholderInfo;
import dev.aurelium.auraskills.slate.info.TemplateInfo;
import dev.aurelium.auraskills.slate.info.TemplatePlaceholderInfo;
import dev.aurelium.auraskills.slate.inv.content.SlotPos;
import dev.aurelium.auraskills.slate.menu.ActiveMenu;
import dev.aurelium.auraskills.slate.util.VersionUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Nullable;

public class StatInfoMenu {
    private final AuraSkills plugin;
    private final ModifierInstances instances;

    public StatInfoMenu(AuraSkills plugin) {
        this.plugin = plugin;
        this.instances = new ModifierInstances(plugin);
    }

    private boolean isDirectTrait(ActiveMenu menu) {
        return menu.property("direct_trait", false);
    }

    public void build(MenuBuilder menu) {
        menu.onOpen(m -> {
            Object patt0$temp;
            Trait trait;
            Stat stat = (Stat)m.menu().getProperty("stat");
            Map<String, ModifierInstance> modifiers = this.instances.getInstances(this.plugin.getUser(m.player()), stat);
            if (stat.hasDirectTrait()) {
                m.menu().setProperty("direct_trait", true);
                trait = stat.getTraits().getFirst();
                m.menu().setProperty("trait", trait);
                modifiers.putAll(this.instances.getInstances(this.plugin.getUser(m.player()), trait, true));
            }
            if ((patt0$temp = m.menu().property("selected")) instanceof Trait) {
                trait = (Trait)patt0$temp;
                m.menu().setProperty("trait", trait);
                modifiers.clear();
                modifiers.putAll(this.instances.getInstances(this.plugin.getUser(m.player()), trait));
            }
            Map<String, ModifierInstance> sortedModifiers = this.instances.sortAndReindex(modifiers);
            m.menu().setProperty("modifiers", sortedModifiers);
        });
        menu.replace("color", p -> this.stat(p).getColor(p.locale()));
        menu.replace("stat_name", p -> this.stat(p).getDisplayName(p.locale(), false));
        GlobalItems globalItems = new GlobalItems(this.plugin);
        menu.item("back", item -> this.getBackItem(this.plugin, (ItemBuilder)item));
        menu.fillItem(globalItems::fill);
        menu.template("stat", Stat.class, template -> {
            template.replace("stat_desc", p -> this.stat(p).getDescription(p.locale(), false));
            template.replace("level", p -> {
                if (this.isDirectTrait(p.menu())) {
                    return NumberUtil.format1(this.user(p).getEffectiveTraitLevel((Trait)p.menu().property("trait")));
                }
                return NumberUtil.format1(this.user(p).getStatLevel(this.stat(p)));
            });
            template.replace("base_level", p -> {
                if (this.isDirectTrait(p.menu())) {
                    return NumberUtil.format1(this.user(p).getUserStats().getTraitBaseAddSum((Trait)p.menu().property("trait")));
                }
                return NumberUtil.format1(this.user(p).getUserStats().getStatBaseAddSum(this.stat(p)));
            });
            template.replace("add_percent_modifiers", p -> {
                if (this.isDirectTrait(p.menu())) {
                    Trait trait = (Trait)p.menu().property("trait");
                    double traitSum = this.user(p).getUserStats().getTraitAddPercentSum(trait);
                    double statSum = this.user(p).getUserStats().getStatAddPercentSum(this.stat(p));
                    return NumberUtil.format1(traitSum + statSum);
                }
                return NumberUtil.format1(this.user(p).getUserStats().getStatAddPercentSum(this.stat(p)));
            });
            template.replace("multiply_modifiers", p -> {
                if (this.isDirectTrait(p.menu())) {
                    Trait trait = (Trait)p.menu().property("trait");
                    double traitProd = this.user(p).getUserStats().getTraitMultiplyProduct(trait);
                    double statProd = this.user(p).getUserStats().getStatMultiplyProduct(this.stat(p));
                    return NumberUtil.format2(traitProd * statProd);
                }
                return NumberUtil.format2(this.user(p).getUserStats().getStatMultiplyProduct(this.stat(p)));
            });
            template.definedContexts(m -> Set.of((Stat)m.menu().property("stat")));
            template.modify(t -> {
                ItemMeta meta;
                ItemStack item = this.hideAttributes(t);
                if (!(t.menu().property("selected") instanceof Trait) && (meta = item.getItemMeta()) != null) {
                    meta.addEnchant(Enchantment.MENDING, 1, true);
                    meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                    item.setItemMeta(meta);
                }
                return item;
            });
            template.onClick(t -> {
                Map<String, Object> props = Map.of("stat", t.menu().property("stat"), "previous_menu", t.menu().property("previous_menu"));
                this.plugin.getSlate().openMenu(t.player(), "stat_info", props);
            });
        });
        menu.template("trait", Trait.class, template -> {
            template.replace("trait_name", p -> ((Trait)p.value()).getDisplayName(p.locale()));
            template.replace("level_modifier", p -> NumberUtil.format2(((Stat)p.menu().property("stat")).getTraitModifier((Trait)p.value())));
            template.replace("level", p -> NumberUtil.format1(this.plugin.getUser(p.player()).getEffectiveTraitLevel((Trait)p.value())));
            template.replace("base_level", p -> NumberUtil.format1(this.plugin.getUser(p.player()).getUserStats().getTraitBaseAddSum((Trait)p.value())));
            template.replace("add_percent_modifiers", p -> NumberUtil.format1(this.plugin.getUser(p.player()).getUserStats().getTraitAddPercentSum((Trait)p.value())));
            template.replace("multiply_modifiers", p -> NumberUtil.format2(this.plugin.getUser(p.player()).getUserStats().getTraitMultiplyProduct((Trait)p.value())));
            template.onClick(t -> {
                Map<String, Object> props = Map.of("stat", t.menu().property("stat"), "selected", t.value(), "previous_menu", (String)t.menu().property("previous_menu"));
                this.plugin.getSlate().openMenu(t.player(), "stat_info", props);
            });
            template.definedContexts(m -> {
                HashSet<Trait> contexts = new HashSet<Trait>();
                for (Trait trait : ((Stat)m.menu().property("stat")).getTraits()) {
                    if (!trait.isEnabled()) continue;
                    contexts.add(trait);
                }
                return contexts;
            });
            template.slotPos(t -> this.getTraitSlot(t.menu(), (Trait)t.value()));
            template.modify(t -> {
                Stat stat = (Stat)t.menu().property("stat");
                if (stat.hasDirectTrait()) {
                    return null;
                }
                if (t.item() == null) {
                    return null;
                }
                ItemStack item = this.hideAttributes(t);
                Object patt0$temp = t.menu().property("selected");
                if (patt0$temp instanceof Trait) {
                    ItemMeta meta;
                    Trait trait = (Trait)patt0$temp;
                    if (((Trait)t.value()).equals(trait) && (meta = item.getItemMeta()) != null) {
                        meta.addEnchant(Enchantment.MENDING, 1, true);
                        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        item.setItemMeta(meta);
                    }
                }
                return item;
            });
        });
        menu.template("modifier", String.class, template -> {
            template.replace("display_name", t -> this.instance(t.menu(), (String)t.value()).displayName());
            template.replace("id", t -> this.instance(t.menu(), (String)t.value()).id());
            template.replace("description", t -> this.instance(t.menu(), (String)t.value()).description());
            template.replace("operation", t -> this.instance(t.menu(), (String)t.value()).operation().getDisplayName());
            template.replace("value", t -> NumberUtil.format2(this.instance(t.menu(), (String)t.value()).value()));
            template.replace("value_format", t -> switch (this.instance(t.menu(), (String)t.value()).operation()) {
                default -> throw new MatchException(null, null);
                case AuraSkillsModifier.Operation.ADD -> this.formatValue(t, "value_add");
                case AuraSkillsModifier.Operation.MULTIPLY -> this.formatValue(t, "value_multiply");
                case AuraSkillsModifier.Operation.ADD_PERCENT -> this.formatValue(t, "value_add_percent");
            });
            template.replace("type_name", t -> {
                NamespaceIdentified type = this.instance(t.menu(), (String)t.value()).parent();
                if (type instanceof Stat || this.stat(t).hasDirectTrait()) {
                    return this.stat(t).getDisplayName(t.locale());
                }
                if (type instanceof Trait) {
                    Trait trait = (Trait)type;
                    return trait.getDisplayName(t.locale());
                }
                return t.placeholder();
            });
            template.definedContexts(m -> {
                Map map = (Map)m.menu().property("modifiers");
                return new HashSet(map.keySet());
            });
            template.slotPos(t -> {
                ModifierInstance instance = this.instance(t.menu(), (String)t.value());
                Object startObj = t.menu().getItemOption("modifier", "start");
                SlotPos start = startObj != null ? GlobalItems.parseSlot(String.valueOf(startObj)) : SlotPos.of(2, 1);
                Object endObj = t.menu().getItemOption("modifier", "end");
                SlotPos end = endObj != null ? GlobalItems.parseSlot(String.valueOf(endObj)) : SlotPos.of(4, 1);
                return this.getRectangleIndex(start, end, instance.index());
            });
            template.modify(t -> {
                if (t.item().equals((Object)ModifierInstances.getFallbackItem())) {
                    ItemStack item = this.instance(t.menu(), (String)t.value()).item();
                    return Objects.requireNonNullElseGet(item, ModifierInstances::getFallbackItem);
                }
                return t.item();
            });
        });
        menu.component("traits_leveled", Stat.class, component -> {
            component.replace("color", p -> this.stat(p).getColor(p.locale()));
            component.shouldShow(c -> !((Stat)c.value()).hasDirectTrait() && !((Stat)c.value()).getTraits().isEmpty());
        });
        menu.component("stat_modifiers_click", Stat.class, component -> component.shouldShow(c -> c.menu().property("selected") instanceof Trait));
        menu.component("showing_stat_modifiers", Stat.class, component -> {
            component.replace("modifier_count", p -> String.valueOf(((Map)p.menu().property("modifiers")).size()));
            component.shouldShow(c -> !(c.menu().property("selected") instanceof Trait));
        });
        menu.component("trait_modifiers_click", Trait.class, component -> component.shouldShow(c -> !((Trait)c.value()).equals(c.menu().property("selected"))));
        menu.component("showing_trait_modifiers", Trait.class, component -> {
            component.replace("modifier_count", p -> String.valueOf(((Map)p.menu().property("modifiers")).size()));
            component.shouldShow(c -> {
                Object patt0$temp = c.menu().property("selected");
                if (!(patt0$temp instanceof Trait)) return false;
                Trait trait = (Trait)patt0$temp;
                if (!((Trait)c.value()).equals(trait)) return false;
                return true;
            });
        });
        menu.component("effective_trait_value", Trait.class, component -> {
            component.replace("trait_name", p -> ((Trait)p.value()).getDisplayName(p.locale()));
            component.replace("effective_value", p -> {
                double level = this.plugin.getUser(p.player()).getEffectiveTraitLevel((Trait)p.value());
                return ((Trait)p.value()).getMenuDisplay(level, p.locale());
            });
            component.shouldShow(c -> {
                BukkitTraitHandler impl = this.plugin.getTraitManager().getTraitImpl((Trait)c.value());
                if (impl != null) {
                    return !impl.displayMatchesValue();
                }
                return false;
            });
        });
    }

    private ModifierInstance instance(ActiveMenu menu, String id) {
        Map map = (Map)menu.property("modifiers");
        return (ModifierInstance)map.get(id);
    }

    private String formatValue(TemplatePlaceholderInfo<String> t, String format) {
        return t.menu().getFormat(format).replace("{value}", NumberUtil.format2(this.instance(t.menu(), t.value()).value()));
    }

    private void getBackItem(AuraSkills plugin, ItemBuilder item) {
        item.replace("menu_name", p -> TextUtil.capitalizeWord(TextUtil.replace((String)p.menu().getProperty("previous_menu"), "_", " ")));
        item.onClick(c -> {
            Map<String, Object> props = Map.of("stat", c.menu().property("stat"), "previous_menu", "skills");
            plugin.getSlate().openMenu(c.player(), (String)c.menu().getProperty("previous_menu"), props);
        });
        item.modify(i -> i.menu().getProperty("previous_menu") == null ? null : i.item());
    }

    private ItemStack hideAttributes(TemplateInfo<?> t) {
        ItemMeta meta = t.item().getItemMeta();
        if (meta == null) {
            return t.item();
        }
        if (VersionUtil.isAtLeastVersion(20, 5)) {
            meta.setAttributeModifiers(Material.IRON_SWORD.getDefaultAttributeModifiers(EquipmentSlot.HAND));
        }
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        t.item().setItemMeta(meta);
        return t.item();
    }

    @Nullable
    private SlotPos getRectangleIndex(SlotPos topLeft, SlotPos bottomRight, int index) {
        int topRow = topLeft.getRow();
        int leftColumn = topLeft.getColumn();
        int bottomRow = bottomRight.getRow();
        int rightColumn = bottomRight.getColumn();
        int numRows = bottomRow - topRow + 1;
        int numColumns = rightColumn - leftColumn + 1;
        int totalSlots = numRows * numColumns;
        if (index < 0 || index >= totalSlots) {
            return null;
        }
        int rowOffset = index / numColumns;
        int columnOffset = index % numColumns;
        int resultRow = topRow + rowOffset;
        int resultColumn = leftColumn + columnOffset;
        return SlotPos.of(resultRow, resultColumn);
    }

    private SlotPos getTraitSlot(ActiveMenu menu, Trait trait) {
        if (menu.getProperties().containsKey(trait.getId().toString())) {
            return (SlotPos)menu.property(trait.getId().toString());
        }
        Object obj = menu.getItemOption("trait", "slots");
        if (obj instanceof List) {
            List<String> slots = DataUtil.castStringList(obj);
            int index = this.getTraitIndex((Stat)menu.property("stat"), trait);
            if (slots.size() > index) {
                String slot = slots.get(index);
                SlotPos slotPos = GlobalItems.parseSlot(slot);
                menu.setProperty(trait.getId().toString(), slotPos);
                return slotPos;
            }
        }
        int index = this.getTraitIndex((Stat)menu.property("stat"), trait);
        SlotPos fallback = SlotPos.of(1, 2 + index);
        menu.setProperty(trait.getId().toString(), fallback);
        return fallback;
    }

    private int getTraitIndex(Stat stat, Trait current) {
        int index = 0;
        for (Trait trait : stat.getTraits()) {
            if (!trait.isEnabled()) continue;
            if (trait.equals(current)) break;
            ++index;
        }
        return index;
    }

    private Stat stat(PlaceholderInfo info) {
        return (Stat)info.menu().property("stat");
    }

    private User user(PlaceholderInfo info) {
        return this.plugin.getUser(info.player());
    }
}

